---
UID: NF:ws2spi.WSCInstallProviderAndChains
title: WSCInstallProviderAndChains function (ws2spi.h)
description: Installs the specified 32-bit transport provider as well as its specific protocol chains into the Winsock 2 system configuration database on a 32-bit computer.
old-location: winsock\wscinstallproviderandchains.htm
tech.root: WinSock
ms.assetid: 592f48b4-5826-449f-b5cc-b0990679fe9f
ms.date: 12/05/2018
ms.keywords: WSCInstallProviderAndChains, WSCInstallProviderAndChains function [Winsock], XP1_IFS_HANDLES, winsock.wscinstallproviderandchains, ws2spi/WSCInstallProviderAndChains
f1_keywords:
- ws2spi/WSCInstallProviderAndChains
dev_langs:
- c++
req.header: ws2spi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Ws2_32.lib
req.dll: Ws2_32.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- DllExport
api_location:
- Ws2_32.dll
api_name:
- WSCInstallProviderAndChains
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# WSCInstallProviderAndChains function


## -description


<div class="alert">**Note**  Layered Service Providers are deprecated. Starting with Windows 8 and Windows Server 2012, use <a href="/windows/desktop/FWP/windows-filtering-platform-start-page">Windows Filtering Platform</a>.</div><div> </div>The **WSCInstallProviderAndChains** function installs the specified 32-bit transport provider as well as its specific protocol chains into the Winsock 2 system configuration database on a 32-bit computer. This function ensures that the protocol chains are ordered at the beginning of the transport provider configuration information, ensuring that a separate call to <a href="/windows/desktop/api/sporder/nf-sporder-wscwriteproviderorder">WSCWriteProviderOrder</a> is not necessary.


## -parameters




### -param lpProviderId [in]

A pointer to a provider-specific, globally unique identifier (GUID).


### -param lpszProviderDllPath [in]

A pointer to a Unicode string containing the load path to the provider's DLL. This string observes the usual rules for path resolution and can contain embedded environment strings (%SystemRoot%, for example). Such environment strings are expanded whenever <i>Ws2_32.dll</i> subsequently loads the provider DLL on behalf of an application. After any embedded environment strings are expanded, <i>Ws2_32.dll</i> passes the resulting string into the <a href="/windows/desktop/api/libloaderapi/nf-libloaderapi-loadlibrarya">LoadLibrary</a> function to load the provider into memory. For more information, see **LoadLibrary**.


### -param lpszLspName [in]

A pointer to a Unicode string that contains the name of the socket provider.


### -param dwServiceFlags [in]

The service flags for the type of "dummy" catalog entry to be created. 

A dummy entry is  a <a href="/windows/win32/api/winsock2/ns-winsock2-wsaprotocol_infoa">WSAProtocol_Info</a> structure with the **ChainLen** member set to 0. The actual LSP catalog entry will reference the ID of this dummy entry in its **ProtocolChain** member.

The possible flags that can be set for this parameter are as follows:

<table>
<tr>
<th>Value</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%"><a id="XP1_IFS_HANDLES"></a><a id="xp1_ifs_handles"></a><dl>
<dt><b>XP1_IFS_HANDLES</b></dl>
</dl>
</td>
<td width="60%">
The catalog entry is for an Installable File System (IFS) LSP, which returns IFS-specific socket handles. These handles are returned directly to the calling application. An IFS LSP cannot intercept the completion of Winsock calls, and does not have to have all Winsock functions implemented or available  on it.

</td>
</tr>
</table>
 


### -param lpProtocolInfoList [in]

A pointer to an array of 
<a href="/windows/win32/api/winsock2/ns-winsock2-wsaprotocol_infoa">WSAProtocol_Info</a> structures. Each structure defines a  protocol, address family, and socket type supported by the provider. The members of the **WSAPROTOCOL_INFO** structure that are examined are **iProtocol**, **iAddressFamily**, and  **iSocketType**.


### -param dwNumberOfEntries [in]

The number of entries in the <i>lpProtocolInfoList</i> array.


### -param lpdwCatalogEntryId [out, optional]

Receives a pointer to the newly-installed "dummy" entry for the transport provider in the Winsock 2 system configuration database. This ID is used to install the catalog entries for the LSP.


### -param lpErrno [out]

A pointer that receives an error code generated by the call if the function fails.


## -returns



If  
**WSCInstallProviderAndChains** succeeds, it returns zero. Otherwise, it returns **SOCKET_ERROR**, and a specific error code is returned in the <i>lpErrno</i> parameter.

<table>
<tr>
<th>Error code</th>
<th>Meaning</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b><a href="/windows/desktop/WinSock/windows-sockets-error-codes-2">WSAEFAULT</a></b></dl>
</dl>
</td>
<td width="60%">
One or more of the arguments is not in a valid part of the user address space.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b><a href="/windows/desktop/WinSock/windows-sockets-error-codes-2">WSAEINVAL</a></b></dl>
</dl>
</td>
<td width="60%">
One or more of the arguments are invalid. This error is returned for the following conditions: the <i>lpProviderId</i> parameter is **NULL**, the <i>lpszProviderDllPath</i> parameter is invalid or the path length is too large (**MAX_PATH** was exceeded), the <i>lpszLspName</i> parameter is invalid or the name length is too large (**WSAPROTOCOL_LEN** is exceeded), the <i>lpProtocolInfoList</i> is set to a non-**NULL** and the <i>dwNumberOfEntries</i> parameter is zero, a duplicate provider  ID or the layered service provider name already exist in the catalog, or a match cannot be found for the specified protocol, address family, and socket type.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b><a href="/windows/desktop/WinSock/windows-sockets-error-codes-2">WSAEINPROGRESS</a></b></dl>
</dl>
</td>
<td width="60%">
A provider installation is already in progress.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b><a href="/windows/desktop/WinSock/windows-sockets-error-codes-2">WSAEINVALIDPROCTABLE</a></b></dl>
</dl>
</td>
<td width="60%">
The provider is missing required functionality.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b><a href="/windows/desktop/WinSock/windows-sockets-error-codes-2">WSAENOBUFS</a></b></dl>
</dl>
</td>
<td width="60%">
 Memory cannot be allocated for buffers.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b><a href="/windows/desktop/WinSock/windows-sockets-error-codes-2">WSANO_RECOVERY</a></b></dl>
</dl>
</td>
<td width="60%">
A nonrecoverable error occurred. This error is returned under several conditions including the following: the provider is already installed, the <i>lpProtocolInfoList</i> parameter was **NULL** and there was no base provider found, the maximum protocol chain length (**MAX_PROTOCOL_CHAIN**) was reached, the user lacks the administrative privileges required to write to the  Winsock registry, or a failure occurred when creating or installing a catalog entry.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b><a href="/windows/desktop/WinSock/windows-sockets-error-codes-2">WSASYSCALLFAILURE</a></b></dl>
</dl>
</td>
<td width="60%">
 A system call that should never fail has failed.

</td>
</tr>
</table>
 




## -remarks



**WSCInstallProviderAndChains** is an enhanced version of the basic <a href="/windows/desktop/api/ws2spi/nf-ws2spi-wscinstallprovider">WSCInstallProvider</a> function used to install a single transport service provider. If a layered service provider is being installed, then **WSCInstallProviderAndChains** should be used.  **WSCInstallProviderAndChains** can install a layered protocol and one or more protocol chains with a single function call. To accomplish the same work using **WSCInstallProvider** would require multiple function calls.

Winsock 2 accommodates layered protocols. A layered protocol is one that implements only higher level communications functions while relying on an underlying transport stack for the actual exchange of data with a remote endpoint. An example of a layered protocol would be a security layer that adds a protocol to the connection establishment process in order to perform authentication and to establish a mutually agreed upon encryption scheme.  Such a security protocol would generally require the services of an underlying reliable transport protocol such as TCP or SPX.  The term base protocol refers to a protocol such as TCP or SPX which is capable of performing data communications with a remote endpoint. The term layered protocol is used to describe a protocol that cannot stand alone.  A protocol chain would then be defined as one or more layered protocols strung together and anchored by a base protocol.
A base protocol has the **ChainLen** member of the <a href="/windows/win32/api/winsock2/ns-winsock2-wsaprotocol_infoa">WSAProtocol_Info</a> structure set to  **BASE_PROTOCOL** which is defined to be 1. A layered protocol has the **ChainLen** member of the **WSAPROTOCOL_INFO** structure set to **LAYERED_PROTOCOL** which is defined to be zero. A protocol chain has the **ChainLen** member of the **WSAPROTOCOL_INFO** structure set to greater than 1.

If <i>lpProtocolInfoList</i> is set to **NULL**, this function creates protocol chains where the provider is layered over the base protocol for each unique protocol type as defined by the address family, socket type, and protocol. This eliminates the creation of any inaccessible duplicate provider entries.

If <i>lpProtocolInfoList</i> is set to a non-**NULL** value, this function creates protocol chains by obtaining the top-most entry  in the configuration information that matches the address family, socket type, and protocol from each element in the provided array. Again, only the address family, socket type, and protocol  are considered; all other members and duplicates are ignored.

Upon successful completion of this call, any subsequent calls to <a href="/windows/desktop/api/winsock2/nf-winsock2-wsaenumprotocolsa">WSAEnumProtocols</a> or  <a href="/windows/desktop/api/ws2spi/nf-ws2spi-wscenumprotocols">WSCEnumProtocols</a> will return the newly-created protocol chain entries. Be aware that in Windows environments, only instances of <i>Ws_32.dll</i> created by calling <a href="/windows/desktop/api/winsock/nf-winsock-wsastartup">WSAStartup</a> after the successful completion  of **WSCInstallProviderAndChains** will include the new entries when **WSAEnumProtocols** and **WSCEnumProtocols** returns. <div class="alert">**Note**   The <a href="/windows/desktop/api/winsock2/nf-winsock2-wsaenumprotocolsa">WSAEnumProtocols</a> function does not enumerate a layered protocol entry while <a href="/windows/desktop/api/ws2spi/nf-ws2spi-wscenumprotocols">WSCEnumProtocols</a> does.</div>
<div> </div>


On success, **WSCInstallProviderAndChains** will attempt to alert all interested applications that have registered for notification of the change by calling <a href="/windows/desktop/api/winsock2/nf-winsock2-wsaproviderconfigchange">WSAProviderConfigChange</a>.

The **WSCInstallProviderAndChains** function can only be called by a user logged on as a member of the Administrators group. If **WSCInstallProviderAndChains** is called by a user that is not a member of the Administrators group, the function call will fail and <a href="/windows/desktop/WinSock/windows-sockets-error-codes-2">WSANO_RECOVERY</a> is returned in the <i>lpErrno</i> parameter. 
 For computers running Windows Vista or Windows Server 2008, this function can also fail because of user account control (UAC). If an application  that contains this function is executed by a user logged on as a member of the Administrators group other than the built-in Administrator, this call will fail unless the application has been marked in the manifest file with a **requestedExecutionLevel** set to **requireAdministrator**. If the application on Windows Vista or Windows Server 2008 lacks this manifest file, a user logged on as a member of the Administrators group other than the built-in Administrator must then be executing the application in an enhanced shell as the built-in Administrator (**RunAs administrator**) for this function to succeed.



Any file installation or provider-specific configuration must be performed by the calling application.




## -see-also




<a href="/windows/desktop/api/libloaderapi/nf-libloaderapi-loadlibrarya">LoadLibrary</a>



<a href="/windows/desktop/WinSock/transport-configuration-and-installation-2">Transport Configuration and Installation</a>



<a href="/windows/desktop/WinSock/transport-service-providers-2">Transport Service Providers</a>



<a href="/windows/desktop/api/winsock2/nf-winsock2-wsaenumprotocolsa">WSAEnumProtocols</a>



<a href="/windows/desktop/api/winsock2/nf-winsock2-wsaproviderconfigchange">WSAProviderConfigChange</a>



<a href="/windows/desktop/api/winsock/nf-winsock-wsastartup">WSAStartup</a>



<a href="/windows/desktop/api/ws2spi/nf-ws2spi-wscenumprotocols">WSCEnumProtocols</a>



<a href="/windows/desktop/api/ws2spi/nf-ws2spi-wscinstallprovider">WSCInstallProvider</a>



<a href="/windows/desktop/api/sporder/nf-sporder-wscwriteproviderorder">WSCWriteProviderOrder</a>
 

 

