---
UID: NS:wsdtypes._WSD_THIS_DEVICE_METADATA
title: WSD_THIS_DEVICE_METADATA (wsdtypes.h)
description: Specifies metadata that is unique to a specific device.
old-location: ncd\wsd_this_device_metadata_struct.htm
tech.root: WsdApi
ms.assetid: 7b9d063f-f0d5-4333-a5d8-e9a6d2d9af88
ms.date: 12/05/2018
ms.keywords: WSD_THIS_DEVICE_METADATA, WSD_THIS_DEVICE_METADATA structure, ncd.wsd_this_device_metadata_struct, wsdtypes/WSD_THIS_DEVICE_METADATA
f1_keywords:
- wsdtypes/WSD_THIS_DEVICE_METADATA
dev_langs:
- c++
req.header: wsdtypes.h
req.include-header: Wsdapi.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WsdTypes.h
api_name:
- WSD_THIS_DEVICE_METADATA
targetos: Windows
req.typenames: WSD_THIS_DEVICE_METADATA
req.redist: 
ms.custom: 19H1
---

# WSD_THIS_DEVICE_METADATA structure


## -description


Specifies metadata that is unique to a specific device.


## -struct-fields




### -field FriendlyName

Reference to a <a href="https://docs.microsoft.com/windows/desktop/api/wsdtypes/ns-wsdtypes-wsd_localized_string_list">WSD_LOCALIZED_STRING_LIST</a> structure that contains the list of localized friendly names for the device. It should be set to fewer than 256 characters.


### -field FirmwareVersion

The firmware version of the device. It should be set to fewer than 256 characters.


### -field SerialNumber

The serial number of the device. It should be set to fewer than 256 characters.


### -field Any

Reference to a <a href="https://docs.microsoft.com/windows/desktop/api/wsdxmldom/ns-wsdxmldom-wsdxml_element">WSDXML_ELEMENT</a> structure that provides an extensible space for devices to add custom metadata to the device specific section. For example, you can use this to add a user-defined name for the device. 


## -remarks



ThisDevice metadata follows this form:



<pre class="syntax" xml:space="preserve"><code>&lt;wsd:ThisDevice&gt;
    &lt;wsd:FriendlyName&gt;
        A. Datum WebWeigh Scale
    &lt;/wsd:FriendlyName&gt;
    &lt;wsd:FirmwareVersion&gt;
        2.53c
    &lt;/wsd:FirmwareVersion&gt;
    &lt;wsd:SerialNumber&gt;
        923450982349058
    &lt;/wsd:SerialNumber&gt;
 &lt;/wsd:ThisDevice&gt;</code></pre>


