---
UID: NF:wsdxml.IWSDXMLContext.AddNamespace
title: IWSDXMLContext::AddNamespace (wsdxml.h)
description: Creates an object that represents a namespace in an XML context.
old-location: ncd\iwsdxmlcontext_addnamespace_method.htm
tech.root: WsdApi
ms.assetid: 8815e01e-1879-48af-9011-84bb622259e9
ms.date: 12/05/2018
ms.keywords: AddNamespace, AddNamespace method, AddNamespace method,IWSDXMLContext interface, IWSDXMLContext interface,AddNamespace method, IWSDXMLContext.AddNamespace, IWSDXMLContext::AddNamespace, ncd.iwsdxmlcontext_addnamespace_method, wsdxml/IWSDXMLContext::AddNamespace
f1_keywords:
- wsdxml/IWSDXMLContext.AddNamespace
dev_langs:
- c++
req.header: wsdxml.h
req.include-header: Wsdapi.h
req.target-type: Windows
req.target-min-winverclnt: Windows Vista [desktop apps only]
req.target-min-winversvr: Windows Server 2008 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: WsdXml.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: Wsdapi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Wsdapi.dll
api_name:
- IWSDXMLContext.AddNamespace
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWSDXMLContext::AddNamespace


## -description


Creates an object that represents a namespace in an XML context. If the namespace already exists, no new namespace will be added, and the namespace object for the existing name will be returned.


## -parameters




### -param pszUri [in]

The URI of the namespace.


### -param pszSuggestedPrefix [in]

The namespace prefix to use when generating XML. If the namespace already exists, <i>pszSuggestedPrefix</i> will overwrite the prefix currently associated with the namespace. The XML context may assign a different namespace prefix. The prefix assigned by the XML context takes precedence over the suggested prefix. The <b>PreferredPrefix</b> member of the structure pointed to by <i>ppNamespace</i> contains the prefix assigned by the XML context. 


### -param ppNamespace [out]

Pointer to the address of the <a href="https://docs.microsoft.com/windows/desktop/api/wsdxmldom/ns-wsdxmldom-wsdxml_namespace">WSDXML_NAMESPACE</a> structure that represents the namespace. You must deallocate <i>ppNamespace</i> by calling <a href="https://docs.microsoft.com/windows/desktop/api/wsdutil/nf-wsdutil-wsdfreelinkedmemory">WSDFreeLinkedMemory</a>. This parameter is optional.


## -returns



Possible return values include, but are not limited to, the following.

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
The method succeeded.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
<i>pszUri</i> is <b>NULL</b>, the length in characters of the URI string exceeds WSD_MAX_TEXT_LENGTH (8192), <i>pszSuggestedPrefix</i> is <b>NULL</b>, or the length in characters of the prefix string exceeds WSD_MAX_TEXT_LENGTH (8192).

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_OUTOFMEMORY</b></dt>
</dl>
</td>
<td width="60%">
Insufficient memory to complete the operation.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_FAIL</b></dt>
</dl>
</td>
<td width="60%">
The method failed.

</td>
</tr>
</table>
 




## -remarks



The returned <a href="https://docs.microsoft.com/windows/desktop/api/wsdxmldom/ns-wsdxmldom-wsdxml_namespace">WSDXML_NAMESPACE</a> structure can be used to force an association between the namespace prefix (as specified by <i>pszSuggestedPrefix</i>) and the namespace URI  (as specified by <i>pszUri</i>). Once this association is established, the  XML generator will produce XML with the specified namespace prefix. 

You can call <b>AddNamespace</b> to retrieve the <a href="https://docs.microsoft.com/windows/desktop/api/wsdxmldom/ns-wsdxmldom-wsdxml_namespace">WSDXML_NAMESPACE</a>  structure created when a namespace was automatically generated by a call to <a href="https://docs.microsoft.com/windows/desktop/api/wsdxml/nf-wsdxml-iwsdxmlcontext-addnametonamespace">AddNameToNamespace</a>. 




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wsdxml/nn-wsdxml-iwsdxmlcontext">IWSDXMLContext</a>
 

 

