---
UID: NF:wsmandisp.IWSMan.get_Error
title: IWSMan::get_Error (wsmandisp.h)
description: Gets additional error information, in an XML stream, for the preceding call to an IWSMan method if Windows Remote Management service was unable to create an IWSManSession object, an IWSManConnectionOptions object, or an IWSManResourceLocator object.
old-location: winrm\iwsman_error.htm
tech.root: winrm
ms.assetid: e85f2e93-9a56-47ca-9bf4-d677dbe07717
ms.date: 12/05/2018
ms.keywords: Error property [Windows Remote Management], Error property [Windows Remote Management],IWSMan interface, IWSMan interface [Windows Remote Management],Error property, IWSMan.Error, IWSMan.get_Error, IWSMan::Error, IWSMan::get_Error, get_Error, winrm.iwsman_error, wsmandisp/IWSMan::Error, wsmandisp/IWSMan::get_Error
f1_keywords:
- wsmandisp/IWSMan.Error
dev_langs:
- c++
req.header: wsmandisp.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows Vista
req.target-min-winversvr: Windows Server 2008
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: WSManDisp.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: WSManDisp.tlb
req.dll: WSMAuto.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- WSMAuto.dll
api_name:
- IWSMan.Error
- IWSMan.get_Error
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IWSMan::get_Error


## -description


Gets additional error information, in an XML stream, for the preceding call to an <a href="https://docs.microsoft.com/windows/desktop/api/wsmandisp/nn-wsmandisp-iwsman">IWSMan</a> method if Windows Remote Management service was unable to create an <a href="https://docs.microsoft.com/windows/desktop/api/wsmandisp/nn-wsmandisp-iwsmansession">IWSManSession</a> object, an <a href="https://docs.microsoft.com/windows/desktop/api/wsmandisp/nn-wsmandisp-iwsmanconnectionoptions">IWSManConnectionOptions</a> object, or an <a href="https://docs.microsoft.com/windows/desktop/api/wsmandisp/nn-wsmandisp-iwsmanresourcelocator">IWSManResourceLocator</a> object.

This property is read-only.


## -parameters


## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wsmandisp/nn-wsmandisp-iwsman">IWSMan</a>
 

 

