---
UID: NE:wtypes.VARENUM
title: VARENUM (wtypes.h)
description: Specifies the variant types.
old-location: automat\varenum.htm
tech.root: automat
ms.assetid: 42da4048-ad98-45b4-8541-d6c912e8f5cf
ms.date: 12/05/2018
ms.keywords: VARENUM, VARENUM enumeration [Automation], VT_ARRAY, VT_BLOB, VT_BLOB_OBJECT, VT_BOOL, VT_BSTR, VT_BSTR_BLOB, VT_BYREF, VT_CARRAY, VT_CF, VT_CLSID, VT_CY, VT_DATE, VT_DECIMAL, VT_DISPATCH, VT_EMPTY, VT_ERROR, VT_FILETIME, VT_HRESULT, VT_I1, VT_I2, VT_I4, VT_I8, VT_INT, VT_INT_PTR, VT_LPSTR, VT_LPWSTR, VT_NULL, VT_PTR, VT_R4, VT_R8, VT_RECORD, VT_SAFEARRAY, VT_STORAGE, VT_STORED_OBJECT, VT_STREAM, VT_STREAMED_OBJECT, VT_UI1, VT_UI2, VT_UI4, VT_UI8, VT_UINT, VT_UINT_PTR, VT_UNKNOWN, VT_USERDEFINED, VT_VARIANT, VT_VECTOR, VT_VERSIONED_STREAM, VT_VOID, _oa96_VARENUM, automat.varenum, wtypes/VARENUM, wtypes/VT_ARRAY, wtypes/VT_BLOB, wtypes/VT_BLOB_OBJECT, wtypes/VT_BOOL, wtypes/VT_BSTR, wtypes/VT_BSTR_BLOB, wtypes/VT_BYREF, wtypes/VT_CARRAY, wtypes/VT_CF, wtypes/VT_CLSID, wtypes/VT_CY, wtypes/VT_DATE, wtypes/VT_DECIMAL, wtypes/VT_DISPATCH, wtypes/VT_EMPTY, wtypes/VT_ERROR, wtypes/VT_FILETIME, wtypes/VT_HRESULT, wtypes/VT_I1, wtypes/VT_I2, wtypes/VT_I4, wtypes/VT_I8, wtypes/VT_INT, wtypes/VT_INT_PTR, wtypes/VT_LPSTR, wtypes/VT_LPWSTR, wtypes/VT_NULL, wtypes/VT_PTR, wtypes/VT_R4, wtypes/VT_R8, wtypes/VT_RECORD, wtypes/VT_SAFEARRAY, wtypes/VT_STORAGE, wtypes/VT_STORED_OBJECT, wtypes/VT_STREAM, wtypes/VT_STREAMED_OBJECT, wtypes/VT_UI1, wtypes/VT_UI2, wtypes/VT_UI4, wtypes/VT_UI8, wtypes/VT_UINT, wtypes/VT_UINT_PTR, wtypes/VT_UNKNOWN, wtypes/VT_USERDEFINED, wtypes/VT_VARIANT, wtypes/VT_VECTOR, wtypes/VT_VERSIONED_STREAM, wtypes/VT_VOID
f1_keywords:
- wtypes/VARENUM
dev_langs:
- c++
req.header: wtypes.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: 
req.target-min-winversvr: 
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: 
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- WTypes.h
api_name:
- VARENUM
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# VARENUM enumeration


## -description


Specifies the variant types.


## -enum-fields




### -field VT_EMPTY

Not specified.


### -field VT_NULL

Null.


### -field VT_I2

A 2-byte integer.


### -field VT_I4

A 4-byte integer.


### -field VT_R4

A 4-byte real.


### -field VT_R8

An 8-byte real.


### -field VT_CY

 Currency.


### -field VT_DATE

A date.


### -field VT_BSTR

A string.


### -field VT_DISPATCH

An <a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/oaidl/nn-oaidl-idispatch">IDispatch</a> pointer.


### -field VT_ERROR

An SCODE value.


### -field VT_BOOL

A Boolean value. True is -1 and false is 0.


### -field VT_VARIANT

A variant pointer.


### -field VT_UNKNOWN

An <a href="https://docs.microsoft.com/windows/desktop/api/unknwn/nn-unknwn-iunknown">IUnknown</a> pointer.


### -field VT_DECIMAL

A 16-byte fixed-pointer value.


### -field VT_I1

A character.


### -field VT_UI1

An unsigned character.


### -field VT_UI2

An unsigned short.


### -field VT_UI4

An unsigned long.


### -field VT_I8

A 64-bit integer.


### -field VT_UI8

A 64-bit unsigned integer.


### -field VT_INT

An integer.


### -field VT_UINT

An unsigned integer.


### -field VT_VOID

A C-style void.


### -field VT_HRESULT

An HRESULT value.


### -field VT_PTR

A pointer type.


### -field VT_SAFEARRAY

A safe array. Use VT_ARRAY in VARIANT.


### -field VT_CARRAY

A C-style array.


### -field VT_USERDEFINED

A user-defined type.


### -field VT_LPSTR

A null-terminated string.


### -field VT_LPWSTR

A wide null-terminated string.


### -field VT_RECORD

A user-defined type.


### -field VT_INT_PTR

A signed machine register size width.


### -field VT_UINT_PTR

An unsigned machine register size width.


### -field VT_FILETIME

A <a href="https://docs.microsoft.com/windows/desktop/api/minwinbase/ns-minwinbase-filetime">FILETIME</a> value.


### -field VT_BLOB

Length-prefixed bytes.


### -field VT_STREAM

The name of the stream follows.


### -field VT_STORAGE

The name of the storage follows.


### -field VT_STREAMED_OBJECT

The stream contains an object.


### -field VT_STORED_OBJECT

The storage contains an object.


### -field VT_BLOB_OBJECT

The blob contains an object.


### -field VT_CF

A clipboard format.


### -field VT_CLSID

A class ID.


### -field VT_VERSIONED_STREAM

A stream with a GUID version.


### -field VT_BSTR_BLOB

Reserved.


### -field VT_VECTOR

A simple counted array.


### -field VT_ARRAY

A SAFEARRAY pointer.


### -field VT_BYREF

A void pointer for local use.


### -field VT_RESERVED


### -field VT_ILLEGAL


### -field VT_ILLEGALMASKED


### -field VT_TYPEMASK




## -remarks



The following table shows where these values can be used.

<table>
<tr>
<th>Value</th>
<th>VARIANT</th>
<th>TYPEDESC</th>
<th>Property set</th>
<th>Safe array</th>
</tr>
<tr>
<td><b>VT_ARRAY</b></td>
<td>X</td>
<td></td>
<td></td>
<td></td>
</tr>
<tr>
<td><b>VT_BLOB</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_BLOB_OBJECT</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_BOOL</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_BSTR</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_BSTR_BLOB</b></td>
<td></td>
<td></td>
<td></td>
<td></td>
</tr>
<tr>
<td><b>VT_BYREF</b></td>
<td>X</td>
<td></td>
<td></td>
<td></td>
</tr>
<tr>
<td><b>VT_CARRAY</b></td>
<td></td>
<td>X</td>
<td></td>
<td></td>
</tr>
<tr>
<td><b>VT_CF</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_CLSID</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_CY</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_DATE</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_DECIMAL</b></td>
<td>X</td>
<td>X</td>
<td></td>
<td>X</td>
</tr>
<tr>
<td><b>VT_DISPATCH</b></td>
<td>X</td>
<td>X</td>
<td></td>
<td>X</td>
</tr>
<tr>
<td><b>VT_EMPTY</b></td>
<td>X</td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_ERROR</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_FILETIME</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_HRESULT</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_I1</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_I2</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_I4</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_I8</b></td>
<td></td>
<td>X</td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_INT</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_INT_PTR</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_LPSTR</b></td>
<td></td>
<td>X</td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_LPWSTR</b></td>
<td></td>
<td>X</td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_NULL</b></td>
<td>X</td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_PTR</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_R4</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_R8</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_RECORD</b></td>
<td>X</td>
<td></td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_SAFEARRAY</b></td>
<td></td>
<td>X</td>
<td></td>
<td></td>
</tr>
<tr>
<td><b>VT_STORAGE</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_STORED_OBJECT</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_STREAM</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_STREAMED_OBJECT</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_UI1</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_UI2</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_UI4</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_UI8</b></td>
<td></td>
<td>X</td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_UINT</b></td>
<td>X</td>
<td>X</td>
<td></td>
<td>X</td>
</tr>
<tr>
<td><b>VT_UINT_PTR</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_UNKNOWN</b></td>
<td>X</td>
<td>X</td>
<td></td>
<td>X</td>
</tr>
<tr>
<td><b>VT_USERDEFINED</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_VARIANT</b></td>
<td>X</td>
<td>X</td>
<td>X</td>
<td>X</td>
</tr>
<tr>
<td><b>VT_VECTOR</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_VERSIONED_STREAM</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
<tr>
<td><b>VT_VOID</b></td>
<td></td>
<td></td>
<td>X</td>
<td></td>
</tr>
</table>
 

<b>VT_BSTR_BLOB</b> is reserved for system use.



