---
UID: NF:wuapi.IDownloadJob.get_AsyncState
title: IDownloadJob::get_AsyncState (wuapi.h)
description: Gets the caller-specific state object that is passed to the IUpdateDownloader.BeginDownload method.
old-location: wua\idownloadjob_asyncstate.htm
tech.root: Wua_Sdk
ms.assetid: 47d2af4a-c04f-4413-ad29-3b8cb1292539
ms.date: 12/05/2018
ms.keywords: AsyncState property [Windows Update Agent], AsyncState property [Windows Update Agent],IDownloadJob interface, IDownloadJob interface [Windows Update Agent],AsyncState property, IDownloadJob.AsyncState, IDownloadJob.get_AsyncState, IDownloadJob::AsyncState, IDownloadJob::get_AsyncState, get_AsyncState, wua.idownloadjob_asyncstate, wuapi/IDownloadJob::AsyncState, wuapi/IDownloadJob::get_AsyncState
f1_keywords:
- wuapi/IDownloadJob.AsyncState
dev_langs:
- c++
req.header: wuapi.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows XP, Windows 2000 Professional with SP3 [desktop apps only]
req.target-min-winversvr: Windows Server 2003, Windows 2000 Server with SP3 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: Wuapi.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: Wuguid.lib
req.dll: Wuapi.dll
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- Wuapi.dll
api_name:
- IDownloadJob.AsyncState
- IDownloadJob.get_AsyncState
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IDownloadJob::get_AsyncState


## -description


Gets  the caller-specific state object that is passed to the <a href="https://docs.microsoft.com/windows/desktop/api/wuapi/nf-wuapi-iupdatedownloader-begindownload">IUpdateDownloader.BeginDownload</a> method.

This property is read-only.


## -parameters


## -remarks



This state object can be used by the caller to identify a particular download. Or, this state object can be used by the caller to pass information from the caller to the implementation of the <a href="https://docs.microsoft.com/windows/desktop/api/wuapi/nn-wuapi-idownloadprogresschangedcallback">IDownloadProgressChangedCallback</a>  or <a href="https://docs.microsoft.com/windows/desktop/api/wuapi/nn-wuapi-idownloadcompletedcallback">IDownloadCompletedCallback</a> interface.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/wuapi/nn-wuapi-idownloadjob">IDownloadJob</a>
 

 

