---
UID: NE:xamlom.RenderTargetBitmapOptions
title: RenderTargetBitmapOptions (xamlom.h)
description: Defines constants that specify what parts of the visual tree should be rendered.
old-location: xaml_diagnostics\rendertargetbitmapoptions.htm
tech.root: xaml_diagnostics
ms.assetid: 02A22436-A11B-4417-9832-1AB0B0FB1FA3
ms.date: 12/05/2018
ms.keywords: RenderTarget, RenderTargetAndChildren, RenderTargetBitmapOptions, RenderTargetBitmapOptions enumeration, xaml_diagnostics.rendertargetbitmapoptions, xamlom/RenderTarget, xamlom/RenderTargetAndChildren, xamlom/RenderTargetBitmapOptions
f1_keywords:
- xamlom/RenderTargetBitmapOptions
dev_langs:
- c++
req.header: xamlom.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10, version 1607 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: XamlOM.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- xamlom.h
api_name:
- RenderTargetBitmapOptions
targetos: Windows
req.typenames: RenderTargetBitmapOptions
req.redist: 
ms.custom: 19H1
---

# RenderTargetBitmapOptions enumeration


## -description


Defines constants that specify what parts of the visual tree should be rendered.


## -enum-fields




### -field RenderTarget

Only the texture associated with the visual should be rendered.


### -field RenderTargetAndChildren

The texture associated with the visual and its children should be rendered.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/xaml_diagnostics/ivisualtreeservice2-rendertargetbitmap">RenderTargetBitmap</a>
 

 

