---
UID: NE:xamlom.ResourceType
title: ResourceType (xamlom.h)
description: Defines constants that specify the type of a resource in a resource dictionary.
old-location: xaml_diagnostics\resourcetype.htm
tech.root: xaml_diagnostics
ms.assetid: F491E78E-86AF-499F-A729-2D534FBA8460
ms.date: 12/05/2018
ms.keywords: ResourceType, ResourceType enumeration, ResourceTypeStatic, ResourceTypeTheme, xaml_diagnostics.resourcetype, xamlom/ResourceType, xamlom/ResourceTypeStatic, xamlom/ResourceTypeTheme
f1_keywords:
- xamlom/ResourceType
dev_langs:
- c++
req.header: xamlom.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 10, version 1607 [desktop apps only]
req.target-min-winversvr: Windows Server 2016 [desktop apps only]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: XamlOM.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- xamlom.h
api_name:
- ResourceType
targetos: Windows
req.typenames: ResourceType
req.redist: 
ms.custom: 19H1
---

# ResourceType enumeration


## -description


Defines constants that specify the type of a resource in a resource dictionary.


## -enum-fields




### -field ResourceTypeStatic

The resource is a <a href="https://docs.microsoft.com/windows/uwp/xaml-platform/staticresource-markup-extension">StaticResource</a>.


### -field ResourceTypeTheme

The resource is a <a href="https://docs.microsoft.com/windows/uwp/xaml-platform/themeresource-markup-extension">ThemeResource</a>.


## -see-also




<a href="https://docs.microsoft.com/previous-versions/windows/desktop/api/xamlom/nf-xamlom-ivisualtreeservice3-resolveresource">ResolveResource</a>
 

 

