---
UID: NE:xpsobjectmodel.__MIDL___MIDL_itf_xpsobjectmodel_0000_0000_0014
title: XPS_OBJECT_TYPE (xpsobjectmodel.h)
description: Describes the type of an object that is derived from IXpsOMShareable.
old-location: xps\xps_object_type.htm
tech.root: printdocs
ms.assetid: 2e53f22e-7521-45c9-ac88-b76fb381f556
ms.date: 12/05/2018
ms.keywords: XPS_OBJECT_TYPE, XPS_OBJECT_TYPE enumeration [XPS Documents and Packaging], XPS_OBJECT_TYPE_CANVAS, XPS_OBJECT_TYPE_GEOMETRY, XPS_OBJECT_TYPE_GLYPHS, XPS_OBJECT_TYPE_IMAGE_BRUSH, XPS_OBJECT_TYPE_LINEAR_GRADIENT_BRUSH, XPS_OBJECT_TYPE_MATRIX_TRANSFORM, XPS_OBJECT_TYPE_PATH, XPS_OBJECT_TYPE_RADIAL_GRADIENT_BRUSH, XPS_OBJECT_TYPE_SOLID_COLOR_BRUSH, XPS_OBJECT_TYPE_VISUAL_BRUSH, xps.xps_object_type, xpsobjectmodel/XPS_OBJECT_TYPE, xpsobjectmodel/XPS_OBJECT_TYPE_CANVAS, xpsobjectmodel/XPS_OBJECT_TYPE_GEOMETRY, xpsobjectmodel/XPS_OBJECT_TYPE_GLYPHS, xpsobjectmodel/XPS_OBJECT_TYPE_IMAGE_BRUSH, xpsobjectmodel/XPS_OBJECT_TYPE_LINEAR_GRADIENT_BRUSH, xpsobjectmodel/XPS_OBJECT_TYPE_MATRIX_TRANSFORM, xpsobjectmodel/XPS_OBJECT_TYPE_PATH, xpsobjectmodel/XPS_OBJECT_TYPE_RADIAL_GRADIENT_BRUSH, xpsobjectmodel/XPS_OBJECT_TYPE_SOLID_COLOR_BRUSH, xpsobjectmodel/XPS_OBJECT_TYPE_VISUAL_BRUSH
f1_keywords:
- xpsobjectmodel/XPS_OBJECT_TYPE
dev_langs:
- c++
req.header: xpsobjectmodel.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: XpsObjectModel.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- HeaderDef
api_location:
- xpsobjectmodel.h
api_name:
- XPS_OBJECT_TYPE
targetos: Windows
req.typenames: XPS_OBJECT_TYPE
req.redist: 
ms.custom: 19H1
---

# XPS_OBJECT_TYPE enumeration


## -description


Describes the type of an object that is derived from <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsomshareable">IXpsOMShareable</a>.


## -enum-fields




### -field XPS_OBJECT_TYPE_CANVAS

The object is an <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsomcanvas">IXpsOMCanvas</a> interface.


### -field XPS_OBJECT_TYPE_GLYPHS

The object is an <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsomglyphs">IXpsOMGlyphs</a> interface.


### -field XPS_OBJECT_TYPE_PATH

The object is an <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsompath">IXpsOMPath</a> interface.


### -field XPS_OBJECT_TYPE_MATRIX_TRANSFORM

The object is an <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsommatrixtransform">IXpsOMMatrixTransform</a> interface.


### -field XPS_OBJECT_TYPE_GEOMETRY

The object is an <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsomgeometry">IXpsOMGeometry</a> interface.


### -field XPS_OBJECT_TYPE_SOLID_COLOR_BRUSH

The object is an <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsomsolidcolorbrush">IXpsOMSolidColorBrush</a> interface.


### -field XPS_OBJECT_TYPE_IMAGE_BRUSH

The object is an <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsomimagebrush">IXpsOMImageBrush</a> interface.


### -field XPS_OBJECT_TYPE_LINEAR_GRADIENT_BRUSH

The object is an <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsomlineargradientbrush">IXpsOMLinearGradientBrush</a> interface.


### -field XPS_OBJECT_TYPE_RADIAL_GRADIENT_BRUSH

The object is an <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsomradialgradientbrush">IXpsOMRadialGradientBrush</a> interface.


### -field XPS_OBJECT_TYPE_VISUAL_BRUSH

The object is an <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsomvisualbrush">IXpsOMVisualBrush</a> interface.


## -see-also




<a href="http://go.microsoft.com/?linkid=8435939">XML Paper Specification</a>
 

 

