---
UID: NF:xpsobjectmodel.IXpsOMPage.GenerateUnusedLookupKey
title: IXpsOMPage::GenerateUnusedLookupKey (xpsobjectmodel.h)
description: Generates a unique name that can be used as a lookup key by a resource in a resource dictionary.
old-location: xps\ixpsompage_generateunusedlookupkey.htm
tech.root: printdocs
ms.assetid: 79599ede-fd81-4d1a-b71b-ac5742e384ca
ms.date: 12/05/2018
ms.keywords: GenerateUnusedLookupKey, GenerateUnusedLookupKey method [XPS Documents and Packaging], GenerateUnusedLookupKey method [XPS Documents and Packaging],IXpsOMPage interface, IXpsOMPage interface [XPS Documents and Packaging],GenerateUnusedLookupKey method, IXpsOMPage.GenerateUnusedLookupKey, IXpsOMPage::GenerateUnusedLookupKey, xps.ixpsompage_generateunusedlookupkey, xpsobjectmodel/IXpsOMPage::GenerateUnusedLookupKey
f1_keywords:
- xpsobjectmodel/IXpsOMPage.GenerateUnusedLookupKey
dev_langs:
- c++
req.header: xpsobjectmodel.h
req.include-header: 
req.target-type: Windows
req.target-min-winverclnt: Windows 7, Windows Vista with SP2 and Platform Update for Windows Vista [desktop apps \| UWP apps]
req.target-min-winversvr: Windows Server 2008 R2, Windows Server 2008 with SP2 and Platform Update for Windows Server 2008 [desktop apps \| UWP apps]
req.kmdf-ver: 
req.umdf-ver: 
req.ddi-compliance: 
req.unicode-ansi: 
req.idl: XpsObjectModel.idl
req.max-support: 
req.namespace: 
req.assembly: 
req.type-library: 
req.lib: 
req.dll: 
req.irql: 
topic_type:
- APIRef
- kbSyntax
api_type:
- COM
api_location:
- xpsobjectmodel.h
api_name:
- IXpsOMPage.GenerateUnusedLookupKey
targetos: Windows
req.typenames: 
req.redist: 
ms.custom: 19H1
---

# IXpsOMPage::GenerateUnusedLookupKey


## -description


Generates a unique name that can be used as a lookup key by a resource in a resource dictionary.


## -parameters




### -param type [in]

The   type of <a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsomshareable">IXpsOMShareable</a> object  for which  the lookup key is generated.


### -param key [out, retval]

The lookup key string that is generated by this method.


## -returns



If the method succeeds, it returns S_OK; otherwise, it returns an <b>HRESULT</b> error code.
          

<table>
<tr>
<th>Return code</th>
<th>Description</th>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>S_OK</b></dt>
</dl>
</td>
<td width="60%">
The method succeeded.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_POINTER</b></dt>
</dl>
</td>
<td width="60%">
<i>key</i> is <b>NULL</b>.

</td>
</tr>
<tr>
<td width="40%">
<dl>
<dt><b>E_INVALIDARG</b></dt>
</dl>
</td>
<td width="60%">
<i>type</i> refers to  an object type that is not recognized.

</td>
</tr>
</table>
 




## -remarks



To be unique in the dictionary, the string generated by <b>GenerateUnusedLookupKey</b> consists of a prefix string that is based on the object type and is followed by four unique alphanumeric characters.

The prefix string for each object type is shown in the following table. 

<table>
<tr>
<th>Object type</th>
<th>Prefix string for this object type</th>
</tr>
<tr>
<td>
XPS_OBJECT_TYPE_CANVAS

</td>
<td>
Canvas_

</td>
</tr>
<tr>
<td>
XPS_OBJECT_TYPE_GEOMETRY

</td>
<td>
Geometry_

</td>
</tr>
<tr>
<td>
XPS_OBJECT_TYPE_GLYPHS

</td>
<td>
Glyphs_

</td>
</tr>
<tr>
<td>
XPS_OBJECT_TYPE_IMAGE_BRUSH

</td>
<td>
IBrush_

</td>
</tr>
<tr>
<td>
XPS_OBJECT_TYPE_LINEAR_GRADIENT_BRUSH

</td>
<td>
LGBrush_

</td>
</tr>
<tr>
<td>
XPS_OBJECT_TYPE_MATRIX_TRANSFORM

</td>
<td>
MTransform_

</td>
</tr>
<tr>
<td>
XPS_OBJECT_TYPE_PATH

</td>
<td>
Path_

</td>
</tr>
<tr>
<td>
XPS_OBJECT_TYPE_RADIAL_GRADIENT_BRUSH

</td>
<td>
RGBrush_

</td>
</tr>
<tr>
<td>
XPS_OBJECT_TYPE_SOLID_COLOR_BRUSH

</td>
<td>
SCBrush_

</td>
</tr>
<tr>
<td>
XPS_OBJECT_TYPE_VISUAL_BRUSH

</td>
<td>
	VBrush_

</td>
</tr>
</table>
 

<div class="alert"><b>Note</b>  <p class="note">This method returns a key string that is unique within the context of this page. It is not guaranteed to 
	 return a key that is unique in a remote dictionary resource that could be used by more than one page.

</div>
<div> </div>
This method allocates the memory used by the string that is returned in <i>key</i>.  If <i>key</i> is not <b>NULL</b>, use the <a href="https://docs.microsoft.com/windows/desktop/api/combaseapi/nf-combaseapi-cotaskmemfree">CoTaskMemFree</a> function  to free the memory.




## -see-also




<a href="https://docs.microsoft.com/windows/desktop/api/xpsobjectmodel/nn-xpsobjectmodel-ixpsompage">IXpsOMPage</a>



<a href="http://go.microsoft.com/?linkid=8435939">XML Paper Specification</a>



<a href="https://docs.microsoft.com/windows/win32/api/xpsobjectmodel/ne-xpsobjectmodel-xps_object_type">XPS_OBJECT_TYPE</a>
 

 

