////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//      JASON - FULLY GRAPHICAL INTERFACE TO HERCULES IBM 360+ EMULATOR       //
//                                                                            //
//                            3215 CONSOLE PRINTER                            //
//                                                                            //
//                             Start: 06.04.2010                              //
//                        Current version: 28.04.2010                         //
//                                                                            //
// Jason is free software; you can redistribute it and/or modify it under     //
// the terms of the GNU General Public License version 3, as published by the //
// Free Software Foundation.                                                  //
//                                                                            //
// Jason is distributed in the hope that it will be useful, but WITHOUT ANY   //
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS  //
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more      //
// details.                                                                   //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program. If not, see <http://www.gnu.org/licenses/>.             //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#pragma hdrstop
#include <stdio.h>
#include <dir.h>

#include "Jason.h"

static COLORREF  conscolors[4] = {     // List of colors for console
  0x00F0CAA6,                          // 0  - Blue
  0x00D0E8E8,                          // 1  - Yellowish
  0x00000080,                          // 2  - Dark red
  0x00000000 };                        // 3  - Black

// Creates new console and connects it to the host. On success, returns pointer
// to console descriptor. On error, sets errmsg and returns NULL.
t_console *Createconsole(int columns,char *hostname,int port,char *parm,
  char *errmsg) {
  int n;
  t_console *pc;
  // Allocate memory for the console.
  pc=(t_console *)GlobalAlloc(GPTR,sizeof(t_console));
  if (pc==NULL) {
    if (errmsg!=NULL)
      strcpy(errmsg,"Unable to create console");
    return NULL; };
  // Make initializations.
  n=Strcopy(pc->telnet.name,SHORTNAME,"UNKNOWN");
  if (parm!=NULL && parm[0]!='\0') {
    pc->telnet.name[n++]='@';
    Strcopy(pc->telnet.name+n,SHORTNAME-n,parm); };
  // Create list.
  pc->list=Createlist(LST_CRLF,columns,4096,conscolors,4);
  if (pc==NULL) {
    GlobalFree((HGLOBAL)pc);
    return NULL; };
  pc->list->userptr=(void *)pc;
  // Add two empty lines. Note that console uses CR/LF mode.
  Addtolist(pc->list,"\n",0,3,1,0);
  Addtolist(pc->list,"\n",0,3,1,0);
  pc->columns=columns;
  // Connect to host.
  if (Connecttohost(&(pc->telnet),hostname,port,errmsg)!=0) {
    Destroylist(pc->list); pc->list=NULL;
    GlobalFree((HGLOBAL)pc);
    return NULL; };
  // Report success.
  return pc;
};

// Opens window associated with the specified console. Several (up to NLISTWIN)
// windows may be attached to the console simultaneously.
HWND Createconsolewindow(t_console *pc,int x,int y,int width,int height,
  HWND hparent,int id,HINSTANCE hinst,HFONT hfont,int options) {
  if (pc==NULL) return NULL;
  return Createlistwindow(pc->list,pc->telnet.name,x,y,width,height,
  hparent,id,hinst,hfont,NULL,options);
};

// This function must be called periodically in order for the console to
// operate. Returns 1 if some actions were necessary and 0 otherwise.
int Consolestep(t_console *pc) {
  int n,ret;
  uchar buf[CMDSIZE];
  if (pc==NULL)
    return 0;                          // Error in input parameters
  ret=0;
  // Process data from telnet stream, as many commands at once as possible.
  while (1) {
    n=Gettelnetdata(&(pc->telnet),buf,sizeof(buf));
    if (n<=0) break;                   // No data or invalid data
    Addtolist(pc->list,(char *)buf,n,3,1,0);
    ret=1;
  };
  return ret;
};

// Frees resources associated with the console.
void Deleteconsole(t_console *pc) {
  if (pc==NULL)
    return;                            // Error in input parameters
  if (pc->list!=NULL)
    Destroylist(pc->list);
  Closetelnet(&(pc->telnet));
  GlobalFree((HGLOBAL)pc);
};

