////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//      JASON - FULLY GRAPHICAL INTERFACE TO HERCULES IBM 360+ EMULATOR       //
//                                                                            //
//                                MAIN PROGRAM                                //
//                                                                            //
//                             Start: 10.02.2010                              //
//                        Current version: 23.02.2010                         //
//                                                                            //
// Jason is free software; you can redistribute it and/or modify it under     //
// the terms of the GNU General Public License version 3, as published by the //
// Free Software Foundation.                                                  //
//                                                                            //
// Jason is distributed in the hope that it will be useful, but WITHOUT ANY   //
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS  //
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more      //
// details.                                                                   //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program. If not, see <http://www.gnu.org/licenses/>.             //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#pragma hdrstop
#include <stdio.h>
#include <dir.h>

#define MAINPROG                       // Place all globals in this object file
#include "Jason.h"
#include "resdata.h"


////////////////////////////////////////////////////////////////////////////////
///////////////////////////////// ABOUT DIALOG /////////////////////////////////

int CALLBACK Adiaabout(HWND hw,UINT msg,WPARAM wp,LPARAM lp) {
  char s[TEXTLEN];
  switch (msg) {
    case WM_INITDIALOG:
      sprintf(s,"\n%s v%i.%02i\n\n"
        "Front-end to Hercules IBM 370 emulator\n\n"
        "%s\n"
        "All Rights Reserved\n\n"
        "The product names mentioned in this\n"
        "software may be trademarks or registered\n"
        "trademarks of their respective owners.\n\n"
        "For the newest information, visit",
        PROGTITLE,VERSIONHI,VERSIONLO,COPYRIGHT);
      SetDlgItemText(hw,ABOUT_TEXT,s);
      SetDlgItemText(hw,ABOUT_WEB,WEBPAGE);
      return TRUE;
    case WM_COMMAND:
      if (LOWORD(wp)==ABOUT_OK || LOWORD(wp)==ABOUT_CANCEL)
        EndDialog(hw,0);
      else if (LOWORD(wp)==ABOUT_WEB) {
        ShellExecute(hw,"open",WEBPAGE,NULL,".",0);
        EndDialog(hw,0); };
      break;
    case WM_SYSCOMMAND:
      if ((wp & 0xFFF0)==SC_CLOSE)
        EndDialog(hw,0);
      break;
    default: break;
  };
  return 0;
};

void About(void) {
  DialogBox(hinst,"ABOUT",hwmain,(DLGPROC)Adiaabout);
};


////////////////////////////////////////////////////////////////////////////////
///////////////////////////////// MAIN WINDOW //////////////////////////////////

static COLORREF  herccolors[3] = {     // List of colors for Hercules console
  0x00000000,                          // 0  - Black
  0x0033BBFF,                          // 1  - Orange
  0x00FFFFFF };                        // 2  - White

static COLORREF  cpucolors[3] = {      // List of colors for CPU console
  0x00FFFFFF,                          // 0  - White
  0x00AAAAAA,                          // 1  - Gray
  0x00000000 };                        // 2  - Black

// Windows function of main Jason window.
LRESULT CALLBACK Mainwp(HWND hw,UINT msg,WPARAM wp,LPARAM lp) {
  int i,n;
  char *filelist;
  POINT pt;
  WINDOWPLACEMENT pl;
  PAINTSTRUCT ps;
  HDC dc;
  HWND hchild,hparent;
  switch (msg) {
    case WM_CREATE:
      DragAcceptFiles(hwmain,TRUE);    // This window accepts drag-and-drop
      break;
    case WM_DROPFILES:
      // Find drag-and-drop target..
      DragQueryPoint((HDROP)wp,&pt);
      hchild=ChildWindowFromPoint(hw,pt);
      while (hchild!=NULL) {
        hparent=GetParent(hchild);
        if (hparent==hw) break;
        hchild=hparent; };
      if (hchild!=hwframe && hchild!=hwdevice) {
        Message("JASN0010E  Invalid drag-and-drop target");
        break; };
      // Get file names.
      n=DragQueryFile((HDROP)wp,0xFFFFFFFF,NULL,0);
      if (n==0) {
        Message("JASN0011E  Invalid drag-and-drop data");
        break; };
      filelist=(char *)GlobalAlloc(GPTR,n*MAXPATH);
      if (filelist==NULL) {
        Message("JASN0012E  Low memory, unable to process drag-and-drop");
        break; };
      for (i=0; i<n; i++)
        DragQueryFile((HDROP)wp,i,filelist+i*MAXPATH,MAXPATH);
      if (hchild==hwframe) {
        ClientToScreen(hw,&pt);
        ScreenToClient(hwframe,&pt);
        Processdraganddrop(&pt,filelist,n,0); }
      else
        Processdraganddrop(NULL,filelist,n,0);
      GlobalFree((HGLOBAL)filelist);
      break;
    case WM_DESTROY:
      pl.length=sizeof(pl);
      GetWindowPlacement(hw,&pl);
      Writetoini("Main","Placement","%i,%i,%i,%i,%i",
        pl.rcNormalPosition.left,pl.rcNormalPosition.top,
        pl.rcNormalPosition.right-pl.rcNormalPosition.left,
        pl.rcNormalPosition.bottom-pl.rcNormalPosition.top,IsZoomed(hw));
      Writetoini("Main","Compact view","%i",compactview);
      DragAcceptFiles(hwmain,FALSE);   // Close drag-and-drop
      hwmain=NULL;                     // Window is no longer available
      PostQuitMessage(0); break;
    case WM_CLOSE:
      DestroyWindow(hw);
      break;
    case WM_WINDOWPOSCHANGING:
      if (((WINDOWPOS *)lp)->cx<MAINDXMIN) ((WINDOWPOS *)lp)->cx=MAINDXMIN;
      if (((WINDOWPOS *)lp)->cy<MAINDYMIN) ((WINDOWPOS *)lp)->cy=MAINDYMIN;
      break;
    case WM_SIZE:
      Resizemainframe();
      Resizedevicewindow();
      break;
    case WM_SETFOCUS:
      SetFocus(hwdevice);
      break;
    case WM_INITMENU:
      CheckMenuItem((HMENU)wp,M_VIEW_COMPACT,
        MF_BYCOMMAND|(compactview?MF_CHECKED:MF_UNCHECKED));
      break;
    case WM_COMMAND:
      if (HIWORD(wp)==0) {             // Message is from menu
        switch (LOWORD(wp)) {
          case M_FILE_STOP:            // Stop Hercules
            Stophercules();
            break;
          case M_FILE_EXIT:            // Close Jason
            DestroyWindow(hwmain);
            break;
          case M_VIEW_COMPACT:         // Compact view
            Compactmainframe(!compactview);
            break;
          case M_SETUP:                // Open Setup dialog
            Setup();
            break;
          case M_HELP_ABOUT:           // Show About Jason dialog
            About();
          break;
        }; }
      break;
    case WM_PAINT:
      dc=BeginPaint(hw,&ps);
      EndPaint(hw,&ps);
      break;
    default: return DefWindowProc(hw,msg,wp,lp);
  };
  return 0L;
};

// Main program.
WINAPI WinMain(HINSTANCE hi,HINSTANCE hprev,LPSTR cmd,int show) {
  int n,actions;
  int xs,ys,x0,y0,dx,dy,iszoomed;
  char s[TEXTLEN],drv[MAXDRIVE],dir[MAXDIR],file[MAXFILE];
  WSADATA wsadata;
  WNDCLASS wc;
  MSG msg;
  POINT pt;
  HWND hwwheel;
  HINSTANCE shlwapi;
  // Current instance of Jason is needed in many system calls. Save it.
  hinst=hi;
  // Initialize Windows Sockets. For no particular reason, I request v2.0.
  if (WSAStartup(0x02,&wsadata)!=0) {
    MessageBox(NULL,"Unable to initialize Windows Sockets",
      PROGTITLE,MB_OK|MB_ICONHAND);
    return 0;
  };
  // Get address of PathRemoveArgs and PathFileExists. My Borland Builder 5 has
  // no import library for shlwapi.dll. Shlwapi is not available on the older
  // systems.
  shlwapi=LoadLibrary("shlwapi.dll");
  if (shlwapi!=NULL) {
    (FARPROC)fileexists=GetProcAddress(shlwapi,"PathFileExistsA");
    (FARPROC)getargs=GetProcAddress(shlwapi,"PathGetArgsA");
    (FARPROC)removeargs=GetProcAddress(shlwapi,"PathRemoveArgsA"); };
  if (shlwapi==NULL || fileexists==NULL || getargs==NULL || removeargs==NULL) {
    MessageBox(NULL,"SHLWAPI.DLL unavailable, please upgrade your system",
      PROGTITLE,MB_OK|MB_ICONHAND);
    return 0;
  };
  // Jason keeps all initializations in the file with the same name as the
  // executable and extention .ini in the directory containing main executable
  // file (Jason.exe).
  GetModuleFileName(NULL,jasonfile,sizeof(jasonfile));
  fnsplit(jasonfile,drv,dir,file,NULL);
  fnmerge(jasondir,drv,dir,NULL,NULL);
  n=strlen(jasondir);
  if (n>0 && jasondir[n-1]=='\\') jasondir[n-1]='\0';
  fnmerge(definifile,drv,dir,file,".ini");
  // By default, Hercules is expected in Jason subdirectory .\hercules.
  if (Stringfromini("Hercules","Executable",hercpath,MAXPATH)==0)
    fnmerge(hercpath,drv,dir,"hercules",".exe");
  if (Stringfromini("Hercules","Configuration",herccfg,MAXPATH)==0) {
    fnsplit(hercpath,drv,dir,file,NULL);
    fnmerge(herccfg,drv,dir,file,".cnf"); };
  // Get other settings.
  nolist=0;
  Getfromini("Hercules","No list","%i",&nolist);
  nocprint=1;
  Getfromini("Hercules","No console printer","%i",&nocprint);
  hidedev=1;
  Getfromini("Hercules","Hide device control buttons","%i",&hidedev);
  whitenempty=0;
  Getfromini("Hercules","Whiten empty edit lines ","%i",&whitenempty);
  iplcuu=0x150;
  Getfromini("Hercules","IPL","%X",&iplcuu);
  editlng=LNG_AUTO;
  Getfromini("Hercules","Language","%i",&editlng);
  rdrportbase=42522;                   // Why not?
  Getfromini("Hercules","RDR port base","%i",&rdrportbase);
  nextrdrport=rdrportbase;
  // Check if configuration is correct.
  if (fileexists(hercpath)==0 || fileexists(herccfg)==0)
    Setup();
  // Initialize variables.
  hercrunning=0;
  // Allocate device list.
  if (Initdevicelist()!=0) {
    MessageBox(NULL,"Low memory",
      PROGTITLE,MB_OK|MB_ICONHAND);
    return 0;
  };
  // Get or create GDI objects we will use in the program.
  btnbrush=CreateSolidBrush(GetSysColor(COLOR_BTNFACE));
  btnpen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_BTNFACE));
  lightpen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_BTNHIGHLIGHT));
  darkpen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DDKSHADOW));
  shadowpen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_BTNSHADOW));
  Createjasonfonts();
  // A very useful small font named Terminal is defined in file "Dosapp.fon"
  // which is not available by default, so I load this file explicitly. In
  // theory, one must broadcast WM_FONTCHANGE, but this may cause problems, so
  // I don't do it.
  AddFontResource("Dosapp.fon");
  // Create list containing Hercules messages.
  herclist=Createlist(0,160,8192,herccolors,3);
  Message("%s v%i.%02i %s",PROGTITLE,VERSIONHI,VERSIONLO,COPYRIGHT);
  // Create fixed-size list containing CPU data.
  cpulist=Createlist(LST_FIXED,60,22,cpucolors,3);
  // Register class of main window.
  wc.style=CS_HREDRAW;
  wc.lpfnWndProc=Mainwp;
  wc.cbClsExtra=wc.cbWndExtra=0;
  wc.hInstance=hinst;
  wc.hIcon=LoadIcon(hinst,"ICO_MAIN");
  wc.hCursor=LoadCursor(NULL,IDC_ARROW);
  wc.hbrBackground=btnbrush;
  wc.lpszMenuName="MAINMENU";
  wc.lpszClassName=MAINCLASS;
  if (RegisterClass(&wc)==0) {
    MessageBox(NULL,"Unable to create main window",
      PROGTITLE,MB_OK|MB_ICONHAND);
    goto finish; };
  // Calculate initial position of main window on the screen.
  xs=GetSystemMetrics(SM_CXSCREEN);    // Size of the screen, pixels
  ys=GetSystemMetrics(SM_CYSCREEN);
  dx=MAINDX;                           // Default size of the main window
  dy=MAINDY;
  x0=(xs-dx)/2;                        // Default position of the main window
  y0=(ys-dy)/2; if (y0>32) y0=32;
  iszoomed=0;
  Getfromini("Main","Placement",
    "%i,%i,%i,%i,%i",&x0,&y0,&dx,&dy,&iszoomed);
  if (dx>xs) dx=xs; if (dx<MAINDXMIN) dx=MAINDXMIN;
  if (dy>ys) dy=ys; if (dy<MAINDYMIN) dy=MAINDYMIN;
  if (x0+dx>xs) x0=xs-dx;              // Force window to be fully visible
  if (y0+dy>ys) y0=ys-dy;
  if (x0<0) x0=0;
  if (y0<0) y0=0;
  compactview=0;
  Getfromini("Main","Compact view","%i",&compactview);
  // Create main window. It will accept drag-and-drop files. Note: this window
  // is initially invisible.
  sprintf(s,"%s v%i.%02i",PROGTITLE,VERSIONHI,VERSIONLO);
  hwmain=CreateWindowEx(
    WS_EX_ACCEPTFILES,MAINCLASS,s,
    WS_OVERLAPPEDWINDOW|WS_CLIPCHILDREN,
    x0,y0,dx,dy,
    NULL,NULL,hinst,NULL);
  if (hwmain==NULL) {
    MessageBox(NULL,"Unable to create main window",PROGTITLE,
      MB_OK|MB_ICONHAND);
    goto finish; };
  // Set background of the mainframe window.
  fillcolor=FILL_USEBG;
  // Extract data from the configuration file.
  Extractcnfdata(herccfg);
  // Register message used by FindText().
  findtextmsgid=RegisterWindowMessage(FINDMSGSTRING);
  hwfindtext=NULL;
  // Create mainframe window and populate it with the default devices.
  if (Createmainframe()==NULL) {
    DestroyWindow(hwmain);
    MessageBox(NULL,"Unable to create main window",
      PROGTITLE,MB_OK|MB_ICONHAND);
    goto finish; };
  // Create device window.
  if (Createdevicewindow()==NULL) {
    DestroyWindow(hwmain);
    MessageBox(NULL,"Unable to create main window",
      PROGTITLE,MB_OK|MB_ICONHAND);
    goto finish; };
  Updatedevices();
  Selectdevice(DEVICE_CONSOLE);
  // Start Hercules.
  if (Starthercules()<0) MessageBox(NULL,
    "Unable to start Hercules. Please check the configuration.",
    PROGTITLE,MB_OK|MB_ICONHAND);
  // Show main window.
  ShowWindow(hwmain,(iszoomed?SW_MAXIMIZE:SW_SHOW));
  // And now, the main Windows loop.
  while (1) {
    // Get and process all Windows messages.
    if (PeekMessage(&msg,NULL,0,0,PM_REMOVE)!=0) {
      // Pass WM_MOUSEWHEEL to the window under the mouse pointer. Note that
      // most standard controls pass this message back to parent. To avoid
      // recursive calls and stack overflow, I pass it only to the custom
      // windows and under the name of WM_USER_WHEEL: it will never bounce
      // back.
      if (hwfindtext!=NULL && IsDialogMessage(hwfindtext,&msg)!=0)
        continue;
      if (msg.message==WM_MOUSEWHEEL) {
        pt.x=LOWORD(msg.lParam);
        pt.y=HIWORD(msg.lParam);
        hwwheel=WindowFromPoint(pt);
        if (hwwheel!=hwmain && hwwheel!=NULL) {
          GetClassName(hwwheel,s,TEXTLEN);
          if (strncmp(s,"JASON",5)==0) {
            SendMessage(hwwheel,WM_USER_WHEEL,msg.wParam,msg.lParam);
            continue;
          };
        };
      };
      TranslateMessage(&msg);
      DispatchMessage(&msg);
      if (msg.message==WM_QUIT) break;
      continue;
    };
    // Get and process next portion of messages and status from Hercules.
    actions=Interface();
    // Process devices.
    actions|=Devicestep();
    // Be nice to other applications.
    if (actions==0) Sleep(1);
  };
  // Close multiple handles that linked us with the Hercules. It is already
  // closed, isn't it? Anyway, Herculess will be killed if still active.
  Stophercules();
  // Update initialization file.
  Writetoini("Hercules","No list","%i",nolist);
  Writetoini("Hercules","No console printer","%i",nocprint);
  Writetoini("Hercules","Hide device control buttons","%i",hidedev);
  Writetoini("Hercules","Whiten empty edit lines ","%i",whitenempty);
  Writetoini("Hercules","IPL","%X",iplcuu);
  Writetoini("Hercules","Language","%i",editlng);
  Writetoini("Hercules","RDR port base","%i",rdrportbase);
  Writetoini("Hercules","Executable","%s",hercpath);
  Writetoini("Hercules","Configuration","%s",herccfg);
  // Free resources.
finish:
  Deletealldevices();
  if (herclist!=NULL) Destroylist(herclist);
  if (cpulist!=NULL) Destroylist(cpulist);
  RemoveFontResource("Dosapp.fon");
  UnregisterClass(MAINCLASS,hinst);
  if (shadowpen!=NULL) DeleteObject(shadowpen);
  if (darkpen!=NULL) DeleteObject(darkpen);
  if (lightpen!=NULL) DeleteObject(lightpen);
  if (btnpen!=NULL) DeleteObject(btnpen);
  if (btnbrush!=NULL) DeleteObject(btnbrush);
  Deletejasonfonts();
  // That's all, folks! (Porky Pig).
  return msg.wParam;
};

