////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//      JASON - FULLY GRAPHICAL INTERFACE TO HERCULES IBM 360+ EMULATOR       //
//                                                                            //
//                             MAIN INCLUDE FILE                              //
//                                                                            //
//                             Start: 10.02.2010                              //
//                        Current version: 30.05.2010                         //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
////////////////////////////// GLOBAL DEFINITIONS //////////////////////////////

#define VERSIONHI      1               // High part of Jason version (X.xx)
#define VERSIONLO      0               // Low part of Jason version (x.XX)

#define PROGTITLE      "Jason"         // Program name

#define COPYRIGHT      "Copyright (C) 2010 Oleh Yuschuk"
#define WEBPAGE        "http://www.ollydbg.de"


////////////////////////////////////////////////////////////////////////////////
////////////// PREFERRED SETTINGS AND FIXES FOR BORLAND COMPILERS //////////////

#ifdef __BORLANDC__
  #pragma option -a1                   // Byte alignment
  #pragma option -K                    // Force unsigned characters!
  #pragma option -w-pin                // Disable "partially bracketed" warning
  // Redefinition of MAKELONG removes nasty warning under Borland Builder 4.0:
  // boolean OR in one row with arithmetical shift.
  #undef  MAKELONG
  #define MAKELONG(lo,hi) ((LONG)(((WORD)(lo))|(((DWORD)((WORD)(hi)))<<16)))
#endif

#define MAKEWP(lo,hi)  ((WPARAM)MAKELONG(lo,hi))
#define MAKELP(lo,hi)  ((LPARAM)MAKELONG(lo,hi))

#define LOINT(l)       ((signed short)((WORD)(l)))
#define HIINT(l)       ((signed short)(((DWORD)(l)>>16) & 0xFFFF))

#ifndef FIELD_OFFSET
  #define FIELD_OFFSET(type,field) ((LONG)&(((type *)0)->field))
#endif


////////////////////////////////////////////////////////////////////////////////
////////////////////////////// GLOBAL DEFINITIONS //////////////////////////////

#define recursive                      // Helps to understand software

#ifndef MAINPROG                       // A trick, define MAINPROG in main file
  #define unique extern
#else
  #define unique
#endif

#define TEXTLEN        256             // Max length of text string
#define SHORTNAME      32              // Max length of short or module name
#define BUFLEN         4096            // Max length of string buffer

typedef unsigned char  uchar;          // Unsigned character (byte)
typedef unsigned short ushort;         // Unsigned short
typedef unsigned int   uint;           // Unsigned integer
typedef unsigned long  ulong;          // Unsigned long

// I am frequently annoyed by the 'Comparing signed and unsigned values'
// warnings issued whenever I write 'if (i+sizeof(x)<j) ...' or similar.
#define sigsize(x)     ((signed)sizeof(x))


////////////////////////////////////////////////////////////////////////////////
////////////////////////////// SERVICE FUNCTIONS ///////////////////////////////

// File types recognized by Verifyfileformat().
#define FF_UNKNOWN     0               // Unknown type or error
#define FF_ASCII       1               // ASCII (US) file
#define FF_EBCDIC      2               // EBCDIC (US) file
#define FF_CKD         3               // DASD image in CKD/CCKD format
#define FF_FBA         5               // DASD image in FBA format
#define FF_AWSTAPE     6               // Tape in AWS format
#define FF_HETTAPE     7               // Tape in HET format

// File extensions supported by Browsefilename().
#define FT_TXT         0x00000001      // *.txt,*.lst
#define FT_PCH         0x00000002      // *.jcl,*.pch
#define FT_DASD        0x00000004      // *.ckd,*.cckd,*.fba,*.dasd
#define FT_TAPE        0x00000008      // *.aws,*.het,*.xmi,*.tape
#define FT_AWS         0x00000010      // *.aws
#define FT_CONFIG      0x00000020      // *.cnf,*.conf
#define FT_EXE         0x00000040      // *.exe
#define FT_BOOK        0x00000080      // *.chm,*.pdf,*.htm,*.txt,*.doc,*.rtf...

// Special fill colors used by Drawbitmap().
#define FILL_USEBG     0xFFFFFFFF      // Fill with bitmap's background
#define FILL_TRANSP    0xFF000000      // Transparent bitmap's background

typedef struct t_font {                // Font descriptor
  HFONT          hfont;                // Handle of the font
  int            stockindex;           // GetStockObject() or 0
  LOGFONT        logfont;              // Font description (stockindex=1)
  int            deleteonexit;         // Not a stock font, delete on exit
  int            dx;                   // Mean width, pixels
  int            dy;                   // Height, pixels
} t_font;

extern char      ebcdic_to_ascii[];    // Converts EBCDIC to ASCII
extern char      ascii_to_ebcdic[];    // Converts ASCII to EBCDIC

int    Strlength(char *src,int n);
int    Strcopy(char *dest,int n,char *src);
int    Verifyfileformat(char *path);

int    Getbitmapsize(char *resource,RECT *rc);
int    Drawbitmap(HDC dc,char *rsrc,RECT *rc,COLORREF fillcolor,int aligntop);

void   Passmousetoparent(HWND hw,UINT msg,WPARAM wp,LPARAM lp);

int    Stringfromini(char *section,char *key,char *s,int length);
int    Getfromini(char *section,char *key,char *format,...);
void   Clearinisection(char *section);
int    Writetoini(char *section,char *key,char *format,...);

int    Createfont(t_font *pf);
void   Createjasonfonts(void);
void   Deletejasonfonts(void);

int    Browsefilename(char *title,char *name,int type,char *defdir,
         HWND hwnd,int issave);

int    Decodeerror(char *s,int n,ulong errcode);
void   Message(char *format,...);


////////////////////////////////////////////////////////////////////////////////
////////////////////////// LOADABLE SYSTEM FUNCTIONS ///////////////////////////

unique BOOL      (WINAPI *fileexists)( // Address of PathFileExistsA()
                 const char *path);
unique char*     (WINAPI *getargs)(    // Address of PathGetArgsA()
                 char *path);
unique void      (WINAPI *removeargs)( // Address of PathRemoveArgsA()
                 char *path);



////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////// LIST /////////////////////////////////////

#define NLISTWIN       2               // Max number of windows displaying list

// List mode bits.
#define LST_FIXED      0x00000001      // Non-scrollable list
#define LST_CRLF       0x00000002      // Scrollable only: honor CR/LF
#define LST_EBCDIC     0x00008000      // Input data in EBCDIC format

// Options for list windows.
#define LWO_ROTATE     0x00000001      // Rotate window by 180 degrees
#define LWO_SCALE      0x00000002      // Scale width into the window
#define LWO_HILITE     0x00000004      // Brighter font
#define LWO_LBORDER    0x00000008      // Add left 1/2-character border
#define LWO_PERFO      0x00000010      // Add perforation borders (TF_PERFO)
#define LWO_SUNKEN     0x00000020      // Add sunken border around the window
#define LWO_SNOWFREE   0x00000040      // Snow-free drawing
#define LWO_NOSCROLL   0x00000080      // Do not scroll & display scroll bars
#define LWO_KEYSCROLL  0x00000100      // Scroll contents using keyboard
#define LWO_CURSOR     0x00000200      // Show cursor, LST_FIXED only
#define LWO_PASSMOUSE  0x00000400      // Pass mouse messages to parent

// Text features.
#define TF_UNDERLINE   0x01            // Underline text
#define TF_PERFO       0x10            // Perforation hole

typedef ulong LISTPROC(HWND,UINT,WPARAM,LPARAM);

typedef struct t_list {                // List descriptor
  // Fields initialized by Createlist().
  ulong          mode;                 // List mode, set of LST_xxx
  int            linesize;             // Length or mean length of the line
  int            linecount;            // Number or expected no. of lines
  uchar          *data;                // List data
  ulong          datasize;             // Size of data buffer
  COLORREF       *colors;              // Colors used by list
  int            ncolors;              // Number of colors used by list
  // Fields used both in fixed and in scroll mode.
  int            lastline;             // Index of last found record or -1
  ulong          lastoffset;           // Offset of last found record
  char           filename[MAXPATH];    // Name of the last saved file
  // Fields used only in fixed mode.
  int            bufferx;              // 0-based X buffer coordinate
  int            buffery;              // 0-based Y buffer coordinate
  int            cursorx;              // 0-based X cursor coordinate
  int            cursory;              // 0-based Y cursor coordinate
  // Fields used only in scroll mode.
  ulong          oldest;               // Offset of oldest record
  ulong          next;                 // Offset to place new record
  int            nlines;               // Current number of records
  // Fields unused by list functions.
  void           *userptr;             // User-defined pointer
  // Attached windows.
  struct {                             // Descriptors of attached windows
    HWND         hw;                   // Handle of the window or NULL
    ulong        options;              // Window options, LWO_xxx
    HFONT        hfont;                // Font used to display data
    int          fontdx;               // Width of font character, pixels
    int          fontdy;               // Height of font character, pixels
    int          offsetx;              // Index of first visible line
    int          offsety;              // Index of first visible column
    LISTPROC     *listproc;            // Custom message callback or NULL
    int          invalidated;          // Spares InvalidateRect()
    int          cursoron;             // Cursor is vislible
  } w[NLISTWIN];
} t_list;

t_list *Createlist(ulong mode,int linesize,int linecount,
         COLORREF *colors,int ncolors);
int    Changelistsize(t_list *pl,int linesize,int linecount);
void   Destroylist(t_list *pl);
int    Getlistwindowsize(t_list *pl,HFONT hfont,int options,
         int *width,int *height);
HWND   Createlistwindow(t_list *pl,char *name,int x,int y,int width,int height,
         HWND hparent,int id,HINSTANCE hinst,HFONT hfont,LISTPROC listproc,
         int options);
void   Addtolist(t_list *pl,char *text,int n,int fgcolor,int bgcolor,
         int features);
void   Setlistposition(t_list *pl,int bufferx,int buffery);
void   Setcursorposition(t_list *pl,int cursorx,int cursory);
void   Clearlist(t_list *pl);
int    Savelisttofile(t_list *pl,int type);


////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////// TELNET ////////////////////////////////////

#define DATALEN        8192            // Max size of data buffer
#define CMDSIZE        8192            // Max size of host command/response

typedef struct t_telnet {              // Descriptor of telnet session
  char           name[SHORTNAME];      // Name of the terminal
  char           hostname[TEXTLEN];    // Host network address
  int            port;                 // Host network port
  int            socket;               // Socket to remote host
  int            socketvalid;          // The above member is defined
  int            reconnecting;         // Auto socket reconnection pending
  uchar          sockbuf[DATALEN];     // Telnet buffer
  int            nsockbuf;             // Size of Telnet buffer data
} t_telnet;

int    Sendhost(t_telnet *ptnt,uchar *data,int ndata);
int    Sendtelnet(t_telnet *ptnt,uchar *data,int ndata);
int    Connecttohost(t_telnet *ptnt,char *hostname,int port,char *errmsg);
int    Gettelnetdata(t_telnet *ptnt,uchar *buf,int maxbuf);
void   Closetelnet(t_telnet *ptnt);


////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// 3270 EMULATION ////////////////////////////////

#define BUFSIZE        4096            // Max size of display buffer

#define TO_3279        0x00000001
//#define TO_ANSI        0x00000002

// 3270 character bits in field attribute mode.
#define FA_PROTECTED   0x20            // Protected field
#define FA_ALPHANUM    0x10            // Alphanumeric field
#define FA_INTMASK     0x0C            // Intensity mask
#define   FA_NORMAL    0x00            // Normal intensity
#define   FA_LIGHTPEN  0x04            // Light pen detectable
#define   FA_BRIGHT    0x08            // High intensity, detectable
#define   FA_FHIDDEN   0x0C            // Field is not displayed
#define FA_MDT         0x01            // Modified data tag

#define FA_AUTOSKIP    (FA_PROTECTED|FA_ALPHANUM)

// 3270 extended attribute fields.
#define EA_MODEMASK    0xC0            // Mask to extract display mode
#define   EA_NORMAL    0x00            // Normal mode
#define   EA_BLINK     0x40            // Blinking character
#define   EA_REVERSE   0x80            // Reversed character
#define   EA_UNDERLINE 0xC0            // Underlined character
#define EA_COLOR       0x38            // Mask to extract color
#define EA_CHARSET     0x07            // Mask to extract character set

typedef struct t_ch {                  // Element of screen buffer
  uchar          c;                    // Character or set of FA_xxx
  uchar          fa;                   // Field attribute marker
  uchar          ea;                   // Extended attributes
  uchar          mbz;                  // Alignment, must be zero
} t_ch;

typedef struct t_3270 {                // 3270 terminal descriptor
  // These fields must be initialized before call to Createterminal().
  int            model;                // 2, 3, 4 or 5
  ulong          options;              // Options, set of TO_xxx
  int            rows;                 // Current number of character rows
  int            columns;              // Current number of character columns
  int            minrows;              // Minimal number of character rows
  int            mincolumns;           // Minimal number of character columns
  int            maxrows;              // Maximal number of character rows
  int            maxcolumns;           // Maximal number of character columns
  // Display.
  t_ch           buf[BUFSIZE];         // Character/attribute buffer
  int            cursor;               // Cursor address
  int            bufaddr;              // Buffer address
  t_list         *list;                // Terminal buffer
  int            programcheck;         // Program check indication
  int            replymode;            // REPLY_xxx
  int            redraw;               // Request to redraw window
  int            isprotected;          // 1: PROT, 2: FA indicator is active
  int            showfields;           // Highlight unprotected fields
  int            reconnecting;         // Last state of reconnection
  // Keyboard.
  int            kbdlock;              // Keyboard lock
  int            insertmode;           // Insert mode
  int            aid;                  // Attention code (AID_xxx) or AID_NO
  // Telnet connection.
  t_telnet       telnet;               // Descriptor of telnet session
} t_3270;

t_3270 *Createterminal(int model,int options,
         char *hostname,int port,char *parm,char *errmsg);
int    Getterminalwindowsize(t_3270 *pt,HFONT hfont,int options,
         int *width,int *height);
HWND   Createterminalwindow(t_3270 *pt,int x,int y,int width,int height,
         HWND hparent,int id,HINSTANCE hinst,HFONT hfont,int options);
int    Terminalstep(t_3270 *pt);
void   Deleteterminal(t_3270 *pt);


////////////////////////////////////////////////////////////////////////////////
////////////////////////////// CONSOLE EMULATION ///////////////////////////////

typedef struct t_console {             // Console descriptor
  int            columns;              // Expected line length, characters
  t_list         *list;                // Console buffer
  // Telnet connection.
  t_telnet       telnet;               // Descriptor of telnet session
} t_console;

t_console *Createconsole(int columns,
         char *hostname,int port,char *parm,char *errmsg);
HWND   Createconsolewindow(t_console *pc,int x,int y,int width,int height,
         HWND hparent,int id,HINSTANCE hinst,HFONT hfont,int options);
int    Consolestep(t_console *pc);
void   Deleteconsole(t_console *pc);


////////////////////////////////////////////////////////////////////////////////
///////////////////////////////// CARD EDITOR //////////////////////////////////

#define MAXUNDO        8192            // Max number of undo actions

// Editor mode bits.
#define EDM_UPCASE     0x00000001      // Convert keyboard input to uppercase
#define EDM_72COL      0x00000002      // Preserve columns 73-80
#define EDM_NOEDIT     0x00000004      // No keyboard/mouse edit
#define EDM_CARD       0x00000008      // Edit on card images

// Languages supported by editor.
#define LNG_NONE       0               // No language
#define LNG_ASM        1               // Assembler
#define LNG_FORTRAN    2               // Fortran
#define LNG_AUTO       3               // Automatic language selection

// Options for edit windows.
#define EDO_LBORDER    0x00000008      // Add left and right 1/2-char borders
#define EDO_SUNKEN     0x00000020      // Add sunken border around the window
#define EDO_SNOWFREE   0x00000040      // Snow-free drawing

// Undo operations.
#define EDU_OPMASK     0x00000007      // Mask to extract operation
#define   EDU_NONE     0x00000000      // No operation
#define   EDU_DEL      0x00000001      // Delete line
#define   EDU_INS      0x00000002      // Insert line
#define   EDU_REPL     0x00000003      // Replace line
#define   EDU_REPF     0x00000004      // Replace line (autofinalization)
#define EDU_FINALIZE   0x00000010      // Finalize previous action

// Loadedit() options.
#define LEO_ADDMASK    0x00000001      // Mask to extract add/replace mode
#define   LEO_ADD      0x00000001      // Add file to the end of editor
#define   LEO_REPLACE  0x00000000      // Replace contents of editor by file
#define LEO_WRAPMASK   0x00000002      // Mask to extract wrapping mode
#define   LEO_WRAP     0x00000000      // Wrap long lines
#define   LEO_TRUNCATE 0x00000002      // Truncate long lines


typedef struct t_undo {                // Header of edit undo item
  int            line;                 // 0-based index of the line
  int            op;                   // Operation, set of EDU_xxx
  int            cursorx;              // Zero-based cursor column
  int            cursory;              // Zero-based cursor line (card)
  int            selx0,sely0;          // Start of selection
  int            selx1,sely1;          // End of selection (not included)
  char           data[0];              // Data follows
} t_undo;

typedef struct t_cardpos {             // Character positions on the card image
  float          basex;                // X position of first character, pixels
  float          basey;                // Y position of the line top, pixels
  float          chardx;               // Distance between characters, pixels
  float          chardy;               // Line height, pixels
} t_cardpos;

typedef struct t_edit {                // Descriptor of the editor
  int            mode;                 // Editor mode, set of EDM_xxx
  int            ncol;                 // Number of columns (default 80)
  int            maxcard;              // Max number of cards in the buffer
  char           *data;                // Data, ncard*ncol bytes
  int            ncard;                // Current number of cards in a deck
  int            cursorx;              // Zero-based cursor column
  int            cursory;              // Zero-based cursor line (card)
  int            selx0,sely0;          // Start of selection
  int            selx1,sely1;          // End of selection (not included)
  int            selxb,selyb;          // Selection base
  int            overwrite;            // 0: insert, 1: overwrite mode
  int            modified;             // Contents is modified
  int            ctrlx;                // 'K': Ctrl+K pressed, 'Q': Ctrl+Q
  char           filename[MAXPATH];    // Name of the loaded file
  int            filevalid;            // File was really loaded from disk
  int            searchflags;          // Search flags, set of FR_xxx
  char           find[TEXTLEN];        // Search pattern
  t_cardpos      cardpos;              // Character positions on the card image
  // Undo buffer.
  uchar          *undo;                // Undo buffer
  int            nundo;                // Current number of elements
  int            nredo;                // Index of last undo element
  int            stopundo;             // Flag that marks undo in progress
  // Attached window.
  struct {                             // Descriptors of attached window
    HWND         hw;                   // Handle of the base window or NULL
    HWND         hstatus;              // Handle of the status bar
    HWND         hedit;                // Handle of the work window or NULL
    ulong        options;              // Window options, EDO_xxx
    HFONT        hfont;                // Font used to display data
    int          fontdx;               // Width of font character, pixels
    int          fontdy;               // Height of font character, pixels
    int          offsetx;              // Index of first visible line
    int          offsety;              // Index of first visible column
    int          invalidated;          // Spares InvalidateRect()
  } w;
} t_edit;

int    Submitedittodevice(t_edit *pe,int cuu,int port);
void   Destroyedit(t_edit *pe);
t_edit *Createedit(ulong mode,int ncol);
HWND   Createeditwindow(t_edit *pe,char *name,int x,int y,int width,int height,
         HWND hparent,int id,HINSTANCE hinst,HFONT hfont,int options);
int    Resetedit(t_edit *pe);
int    Loadedit(t_edit *pe,char *path,int options);
int    Loadeditfile(t_edit *pe);
int    Addeditline(t_edit *pe,char *s,int n);
int    Saveeditfile(t_edit *pe,int asknewname);
void   Toggleeditview(t_edit *pe);
int    Iseditcontentschanged(t_edit *pe);

int    Drawcard(HDC dc,RECT *rc,COLORREF bg,int lineno,char *text,
         int sel0,int sel1,t_cardpos *cp);
int    Getcardcharrect(t_cardpos *cp,int index,RECT *rc);
int    Getcardcharindex(t_cardpos *cp,int x);
void   Setcardcaret(HWND hw,t_cardpos *cp,int cursorx,int overwrite);


////////////////////////////////////////////////////////////////////////////////
//////////////////////////// INTERFACE TO HERCULES /////////////////////////////

#define NBUF           (TEXTLEN*4)     // Size of pipe data buffers

typedef struct t_pipe {                // Pipe descriptor
  char           pipename[MAXPATH];    // Name of the pipe or empty string
  char           filename[MAXPATH];    // Name of the output file
  int            mode;                 // 0 - fixed, 1 - text, 2 - variable mode
  HANDLE         hpipe;                // Jason's end of the pipe
  HANDLE         hfile;                // Output file or NULL
  char           buf[NBUF];            // Data buffer
  int            nbuf;                 // Actual size of data in buf
} t_pipe;

unique t_pipe    outpipe;              // Pipe for Hercules's stdout
unique t_pipe    errpipe;              // Pipe for Hercules's stderr

unique char      archmode[SHORTNAME];  // Mainframe architecture
unique int       cpumodel;             // CPU model (NNNN, decimal)
unique int       cnslport;             // Port that 3270 attaches to

unique ulong     cpuregs[4];           // CPU registers 0..3
unique ulong     cpuip;                // CPU IP
unique ulong     cpupsw;               // CPU PSW

int    Openpipe(t_pipe *pp,char *pipename,char *filename,
         int pipemode,int mode);
int    Readpipe(t_pipe *pp,char *s,int n);
void   Closepipe(t_pipe *pp);

void   Extractcnfdata(char *path);
int    Starthercules(void);
int    Sendstdin(char *format,...);
void   Stophercules(void);
int    Callutility(char *utility,char *parms,t_list *pl,
         char *filter,char *out,int nostderr);
int    Interface(void);


////////////////////////////////////////////////////////////////////////////////
////////////////////////////// DEVICE SUBWINDOWS ///////////////////////////////

HWND   Createcpufrontpanel(HWND hparent,int x0,int y0,int dx,int dy);
int    Getiplpanelsize(int *width,int *height);
HWND   Createiplpanel(HWND hparent,int x0,int y0);
HWND   Createstatepanel(HWND hparent,int x0,int y0,ulong state);
int    Setstatepanelstate(HWND hw,ulong state);


////////////////////////////////////////////////////////////////////////////////
//////////////////////////// MAINFRAME AND DEVICES /////////////////////////////

#define MAXDEVICE      128             // Max number of movable devices

#define DEVICE_HELP    0               // Index of Help device
#define DEVICE_CONSOLE 1               // Index of Hercules console device
#define DEVICE_CPU     2               // Index of CPU device
#define NDEVRESERVED   3               // Number of reserved devices

#define STATEDX        25              // Width of state window
#define STATEDY        7               // Height of state window

#define DEV_NONE       0               // No device or placeholder
#define DEV_UNKNOWN    1               // Device of unknown type
#define DEV_SHELF      2               // Bookshelf
#define DEV_HERC       3               // Hercules console
#define DEV_CPU        4               // CPU
#define DEV_RDR        5               // Card reader
#define DEV_PCH        6               // Card puncher
#define DEV_PRT        7               // Line printer
#define DEV_CON        8               // Console printer
#define DEV_DSP        9               // Display terminal
#define DEV_DASD       10              // Direct Access Storage
#define DEV_TAPE       11              // Tape

#define DCH_CONFIRMED  0x8000          // Device presence is confirmed
#define DCH_NEW        0x0800          // New device
#define DCH_REPLACED   0x0400          // Device is replaced by different
#define DCH_DELETED    0x0200          // Device is removed
#define DCH_STATE      0x0002          // State of the device has changed
#define DCH_FILE       0x0001          // Attached file has changed

// Device state bits
#define DS_ONLINE      0x01            // Device online
#define DS_BUSY        0x02            // Device busy
#define DS_PENDING     0x04            // I/O operation pending
#define DS_OPEN        0x08            // Device attached to file

typedef struct t_device {
  // Fields used mainly in communication with Hercules.
  int            devclass;             // Device class, one of DEV_xxx
  int            cuu;                  // Device address (CCUU, hexadecimal)
  int            devtype;              // Device type (NNNN, decimal)
  ulong          state;                // Device state, set of DS_xxx
  int            protect;              // Whether write-protected media
  char           file[MAXPATH];        // Path to file
  char           last[MAXPATH];        // Last loaded volume
  // Fields used in Jason device presentation.
  char           devname[SHORTNAME];   // Device name
  char           bitmap[SHORTNAME];    // Name of bitmap resource
  RECT           bitmapsize;           // Dimensions of the bitmap resource
  char           protmap[SHORTNAME];   // Name of protected media bitmap
  char           unprmap[SHORTNAME];   // Name of unprotected media bitmap
  int            changed;              // Device state changed, set of DCH_xxx
  int            selected;             // Device is selected to main window
  COLORREF       background;           // Colour of device background
  // Animation.
  HWND           listhw;               // List window associated with device
  RECT           listrc;               // List rectangle relative to device
  HWND           statehw;              // Device state window
  RECT           staterc;              // State rectangle relative to device
  char           text[SHORTNAME];      // Custom text
  RECT           textrc;               // Custom text rectangle
  // Associated goodies.
  t_pipe         *pipe;                // Pointer to pipe descriptor
  t_list         *list;                // List associated with device
  t_edit         *edit;                // Editor associated with device
  int            linecount;            // Line count on actual print page
  t_console      *console;             // Console associated with device
  t_3270         *terminal;            // 3270 terminal associated with device
  int            rdrport;              // TCP/IP port associated with reader
} t_device;

unique COLORREF  fillcolor;            // Color that fills mainframe background

unique t_device  *device;              // List of devices
unique int       maxdevice;            // Number of slots in device list
unique int       ndevice;              // Current number of devices
unique int       executeff;            // Expand Form Feed to paper feed
unique int       compactview;          // Compact view of mainframe
unique int       iplcuu;               // CUU of IPL device, hexadecimal
unique int       editlng;              // Editor language, one of LNG_xxx

unique int       rdrportbase;          // Base of card reader ports
unique int       nextrdrport;          // Next free card reader port

int    Devicefromclient(int x,int *xorigin);
HWND   Createmainframe(void);
void   Resizemainframe(void);
void   Compactmainframe(int compact);

void   Processdraganddrop(POINT *pt,char *filelist,int nfile,int unprotect);
void   Selectdevice(int select);
void   Reselectdevice(void);
HWND   Createdevicewindow(void);
void   Resizedevicewindow(void);
void   Redrawcpupanel(void);
void   Updatedevices(void);
int    Devicestep(void);
void   Deletealldevices(void);
int    Initdevicelist(void);


////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////// SETUP /////////////////////////////////////

unique char      hercpath[MAXPATH];    // Path to Hercules executable
unique char      herccfg[MAXPATH];     // Path to Hercules configuration file
unique int       nolist;               // Don't list DASD and TAPE contents
unique int       nocprint;             // Don't connect console printer
unique int       hidedev;              // Hide device control buttons
unique int       hilitesel;            // Change background of selected device

unique int       whitenempty;          // Show empty edit lines in low tones

int    Setup(void);


////////////////////////////////////////////////////////////////////////////////
///////////////////////////////// MAIN PROGRAM /////////////////////////////////

// Class names of all Jason windows that want to receive WM_MOUSEWHEEL must
// begin with "JASON".
#define MAINCLASS      "JASON"         // Class name of main window
#define FRAMECLASS     "JASONFRAME"    // Class name of the mainframe child
#define DEVICECLASS    "JASONDEVICE"   // Class name of the device child
#define LISTCLASS      "JASONLIST"     // Class name of list window
#define EBASECLASS     "JASONEBASE"    // Class name of base editor window
#define EDITCLASS      "JASONEDIT"     // Class name of work editor window

#define MAINDX         1024            // Initial width of main window
#define MAINDY         768             // Initial height of main window
#define MAINDXMIN      640             // Minimal allowed width of main window
#define MAINDYMIN      600             // Minimal allowed height of main window
#define BORDER         4               // Border around child windows
#define FRAMEDY        320             // Height of mainframe
#define DEVICEDY       100             // Minimal height of device window
#define BUTTONDX       100             // Width of auxiliary buttons
#define BUTTONDY       30              // Height of auxiliary buttons
#define IPLBTNDX       100             // Width of IPL button
#define IPLBTNDY       40              // Height of IPL button

#define WM_USER_WHEEL  (WM_USER+100)   // Customized mouse wheel message

unique HINSTANCE hinst;                // Current program instance
unique HPEN      btnpen;               // Button face pen
unique HPEN      darkpen;              // Button dark shadow pen
unique HPEN      shadowpen;            // Button shadow pen
unique HPEN      lightpen;             // Button hilite pen
unique HBRUSH    btnbrush;             // Button face brush
unique HWND      hwmain;               // Handle of the main window
unique HWND      hwframe;              // Handle of the mainframe window
unique HWND      hwdevice;             // Handle of the device window
unique ulong     findtextmsgid;        // Message used by FindText()
unique HWND      hwfindtext;           // Handle of FindText() window

unique int       uniquenumber;         // Used to create unique pipe names

unique char      jasonfile[MAXPATH];   // Path to Jason
unique char      jasondir[MAXPATH];    // Jason directory without backslash
unique char      definifile[MAXPATH];  // Initialization file (jason.ini)
unique char      hercdir[MAXPATH];     // Directory where Hercules resides

// General purpose fonts.
unique t_font    sysfont;              // Small proportional font
unique t_font    mediumfont;           // Medium-size proportional font
unique t_font    largefont;            // Rather big proportional font
unique t_font    smallfixfont;         // Small fixed Terminal font
unique t_font    lucidafont;           // Small fixed Lucida Console font
unique t_font    smallcardfont;        // Font for column numbers on cards
// List fonts.
unique t_font    dspfont;              // 3270 display font
unique t_font    consfont;             // Console font
unique t_font    editfont;             // Editor font
unique t_font    prtfont;              // Printer font
unique t_font    hercfont;             // Hercules console and CPU font

unique t_list    *herclist;            // List containing Hercules messages
unique t_list    *cpulist;             // List that keeps CPU data

unique int       hercrunning;          // Whether Hercules is running

