////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//      JASON - FULLY GRAPHICAL INTERFACE TO HERCULES IBM 360+ EMULATOR       //
//                                                                            //
//                                SETUP DIALOG                                //
//                                                                            //
//                             Start: 26.04.2010                              //
//                        Current version: 30.05.2010                         //
//                                                                            //
// Jason is free software; you can redistribute it and/or modify it under     //
// the terms of the GNU General Public License version 3, as published by the //
// Free Software Foundation.                                                  //
//                                                                            //
// Jason is distributed in the hope that it will be useful, but WITHOUT ANY   //
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS  //
// FOR A PARTICULAR PURPOSE. See the GNU General Public License for more      //
// details.                                                                   //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program. If not, see <http://www.gnu.org/licenses/>.             //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

#include <windows.h>
#pragma hdrstop
#include <stdio.h>
#include <dir.h>

#include "Jason.h"
#include "resdata.h"


// Service function, selects new font.
static void Editfont(HWND hw,t_font *pf) {
  CHOOSEFONT cf;
  if (pf==NULL)
    return;                            // Error in input parameters
  memset(&cf,0,sizeof(cf));
  cf.lStructSize=sizeof(cf);
  cf.hwndOwner=hw;
  cf.hDC=NULL;
  cf.lpLogFont=&(pf->logfont);
  cf.Flags=CF_FIXEDPITCHONLY|CF_FORCEFONTEXIST|CF_INITTOLOGFONTSTRUCT|
    CF_LIMITSIZE|CF_NOVERTFONTS|CF_SCREENFONTS;
  cf.rgbColors=RGB(0,0,0);
  cf.nSizeMin=1;
  cf.nSizeMax=24;
  ChooseFont(&cf);
};

// Dialog function of Setup dialog.
int CALLBACK Setupdlgfunc(HWND hw,UINT msg,WPARAM wp,LPARAM lp) {
  int result;
  char path[MAXPATH];
  switch (msg) {
    case WM_INITDIALOG:
      SetDlgItemText(hw,SET_HERCEXE,hercpath);
      SetDlgItemText(hw,SET_HERCCONF,herccfg);
      CheckDlgButton(hw,SET_LIST,nolist?BST_UNCHECKED:BST_CHECKED);
      CheckDlgButton(hw,SET_CPRINT,nocprint?BST_UNCHECKED:BST_CHECKED);
      CheckDlgButton(hw,SET_SHOWDEV,hidedev?BST_UNCHECKED:BST_CHECKED);
      CheckDlgButton(hw,SET_HILITESEL,hilitesel?BST_CHECKED:BST_UNCHECKED);
      SendDlgItemMessage(hw,SET_DSPFONT,WM_SETFONT,(WPARAM)dspfont.hfont,0);
      SendDlgItemMessage(hw,SET_CONSFONT,WM_SETFONT,(WPARAM)consfont.hfont,0);
      SendDlgItemMessage(hw,SET_EDITFONT,WM_SETFONT,(WPARAM)editfont.hfont,0);
      SendDlgItemMessage(hw,SET_PRTFONT,WM_SETFONT,(WPARAM)prtfont.hfont,0);
      SendDlgItemMessage(hw,SET_HERCFONT,WM_SETFONT,(WPARAM)hercfont.hfont,0);
      CheckRadioButton(hw,SET_LNONE,SET_LAUTO,SET_LNONE+editlng);
      break;
    case WM_COMMAND:
      switch (LOWORD(wp)) {
        case SET_BROWSEEXE:
          GetDlgItemText(hw,SET_HERCEXE,path,MAXPATH);
          result=Browsefilename("Locate Hercules executable file",path,
            FT_EXE,".\hercules",hw,0);
          if (result==0)
            SetDlgItemText(hw,SET_HERCEXE,path);
          break;
        case SET_BROWSECONF:
          GetDlgItemText(hw,SET_HERCCONF,path,MAXPATH);
          result=Browsefilename("Locate Hercules configuration file",path,
            FT_CONFIG,".\hercules",hw,0);
          if (result==0)
            SetDlgItemText(hw,SET_HERCCONF,path);
          break;
        case SET_SHOWDEV:
          hidedev=(IsDlgButtonChecked(hw,SET_SHOWDEV)==BST_CHECKED?0:1);
          Reselectdevice();
          break;
        case SET_HILITESEL:
          hilitesel=(IsDlgButtonChecked(hw,SET_HILITESEL)==BST_CHECKED?1:0);
          Reselectdevice();
          break;
        case SET_DSPFONT:
          Editfont(hw,&dspfont);
          Createfont(&dspfont);
          SendDlgItemMessage(hw,SET_DSPFONT,WM_SETFONT,
            (WPARAM)dspfont.hfont,0);
          Reselectdevice();
          break;
        case SET_CONSFONT:
          Editfont(hw,&consfont);
          Createfont(&consfont);
          SendDlgItemMessage(hw,SET_CONSFONT,WM_SETFONT,
            (WPARAM)consfont.hfont,0);
          Reselectdevice();
          break;
        case SET_EDITFONT:
          Editfont(hw,&editfont);
          Createfont(&editfont);
          SendDlgItemMessage(hw,SET_EDITFONT,WM_SETFONT,
            (WPARAM)editfont.hfont,0);
          Reselectdevice();
          break;
        case SET_PRTFONT:
          Editfont(hw,&prtfont);
          Createfont(&prtfont);
          SendDlgItemMessage(hw,SET_PRTFONT,WM_SETFONT,
            (WPARAM)prtfont.hfont,0);
          Reselectdevice();
          break;
        case SET_HERCFONT:
          Editfont(hw,&hercfont);
          Createfont(&hercfont);
          SendDlgItemMessage(hw,SET_HERCFONT,WM_SETFONT,
            (WPARAM)hercfont.hfont,0);
          Reselectdevice();
          break;
        case SET_LNONE:
        case SET_LASM:
        case SET_LFORTRAN:
        case SET_LAUTO:
          editlng=LOWORD(wp)-SET_LNONE;
          Reselectdevice();
          break;
        case IDOK:
          GetDlgItemText(hw,SET_HERCEXE,hercpath,MAXPATH);
          GetDlgItemText(hw,SET_HERCCONF,herccfg,MAXPATH);
          nolist=(IsDlgButtonChecked(hw,SET_LIST)==BST_CHECKED?0:1);
          nocprint=(IsDlgButtonChecked(hw,SET_CPRINT)==BST_CHECKED?0:1);
          EndDialog(hw,0);
          break;
        case IDCANCEL:
          EndDialog(hw,-1);
        break;
      };
      break;
    case WM_SYSCOMMAND:
      if ((wp & 0xFFF0)==SC_CLOSE)
        EndDialog(hw,-1);
      return 0;
    default: return 0;
  };
  return 1;
};

// Sets up Jason parameters. Returns 0 if user pressed OK and -1 on cancel.
int Setup(void) {
  return DialogBox(hinst,"SETUP",hwmain,(DLGPROC)Setupdlgfunc);
};

